/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.lucene;

import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.lucene.LuceneDateUtilsBridge;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.lucene.LuceneDateUtilsBridge812")
@SupportedVersions(all=true)
public class LuceneDateUtilsBridge812
implements LuceneDateUtilsBridge {
    @Override
    public long luceneDateToMillis(String luceneDate) {
        long daysSinceEpoch = Long.parseLong(luceneDate);
        LocalDate jiraDate = new LocalDate(daysSinceEpoch);
        DateTime jodaDateTime = new DateTime(jiraDate.getYear(), jiraDate.getMonth(), jiraDate.getDay(), 0, 0, DateTimeZone.UTC);
        return jodaDateTime.getMillis();
    }

    @Override
    public String millisToLuceneDate(long millis) {
        org.joda.time.LocalDate jodaDate = new org.joda.time.LocalDate(millis, DateTimeZone.UTC);
        LocalDate jiraDate = new LocalDate(jodaDate.getYear(), jodaDate.getMonthOfYear(), jodaDate.getDayOfMonth());
        return Long.toString(jiraDate.getEpochDays());
    }

    @Override
    public long luceneDateTimeToMillis(String millis) {
        return Long.parseLong(millis);
    }

    @Override
    public String millisToLuceneDateTime(long millis) {
        return Long.toString(millis);
    }
}

