/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IItemAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.AbstractWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IUnstructuredItemSchedule;
import com.google.common.base.Optional;
import javax.annotation.Nullable;

public abstract class AbstractRemainingWorkItemWarning
extends AbstractWarning {
    protected final Float unscheduledWorkAmount;

    AbstractRemainingWorkItemWarning(IItemAssignmentProblem assignmentProblem, @Nullable IUnstructuredItemSchedule schedule) {
        super(assignmentProblem.getId());
        this.unscheduledWorkAmount = Float.valueOf(AbstractRemainingWorkItemWarning.calculateOpenAmount(assignmentProblem, schedule));
    }

    AbstractRemainingWorkItemWarning(String id) {
        super(id);
        this.unscheduledWorkAmount = null;
    }

    private static float calculateOpenAmount(IItemAssignmentProblem assignmentProblem, @Nullable IUnstructuredItemSchedule schedule) {
        float assignmentProblemWork = assignmentProblem.getProcessingItem().getWorkDemand().getPositiveTypeAmounts().getValueSum();
        if (schedule != null) {
            float scheduledAmount = schedule.getAggregatedWorkPackage().getPositiveTypeAmounts().getValueSum();
            return assignmentProblemWork - scheduledAmount;
        }
        return assignmentProblemWork;
    }

    public Optional<Float> getUnscheduledWorkAmount() {
        return Optional.fromNullable((Object)this.unscheduledWorkAmount);
    }
}

