/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisodeStream;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Deprecated
@Immutable
public class LegacyEpisodeStream
implements IEpisodeStream {
    private final String id;
    private final List<IEpisode> episodes;
    private final Set<String> assignableGroupIds;

    public LegacyEpisodeStream(String id, List<IEpisode> episodes, Set<String> assignableGroupIds) {
        Preconditions.checkNotNull(episodes, (Object)"list of episodes must not be null");
        Preconditions.checkArgument((!episodes.isEmpty() ? 1 : 0) != 0, (Object)"list if episodes must not be empty");
        Preconditions.checkArgument((boolean)episodes.get(0).getFixedStartTime().isPresent(), (Object)"first episode must have start time");
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id must not be null");
        this.episodes = Collections.unmodifiableList(episodes);
        this.assignableGroupIds = Collections.unmodifiableSet((Set)Preconditions.checkNotNull(assignableGroupIds, (Object)"set of assignable group IDs must not be null"));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<IEpisode> getEpisodes() {
        return this.episodes;
    }

    @Override
    public Set<String> getAssignableGroupIds() {
        return this.assignableGroupIds;
    }

    @Override
    public IEpisode getEpisode(final String episodeId) {
        return (IEpisode)Iterables.find(this.episodes, (Predicate)new Predicate<IEpisode>(){

            public boolean apply(@Nullable IEpisode episode) {
                return episodeId.equals(episode.getId());
            }
        });
    }

    @Override
    public boolean isEpisodeStrictlyBefore(String episodeId1, String episodeId2) {
        int index2;
        int index1 = RmIdentifiableUtils.getIndex(episodeId1, this.episodes);
        if (index1 >= (index2 = RmIdentifiableUtils.getIndex(episodeId2, this.episodes))) {
            return false;
        }
        for (int i = index2; i > index1; --i) {
            if (!this.episodes.get(i).getFixedStartTime().isPresent()) continue;
            return false;
        }
        return true;
    }

    @Override
    public IEpisode getLatestEpisode() {
        return this.episodes.get(this.episodes.size() - 1);
    }

    public String toString() {
        return "LegacyEpisodeStream [id=" + this.id + ", episodes=" + Joiner.on((String)",").join(this.episodes) + "]";
    }
}

