/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivity;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IStageTask;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Immutable
public class Activity
implements IActivity {
    private final String id;
    private final IProcessingStageWorkPackage activityDemand;
    private final List<IStageTask> subTasks;
    private final PositivePrimitivesMap<IResourceType> overallDemand;
    private final IProcessingStage stage;

    public Activity(String id, IProcessingStageWorkPackage activityDemand) {
        this(id, activityDemand.getProcessingStage(), (Optional<IProcessingStageWorkPackage>)Optional.of((Object)activityDemand), Lists.newArrayList());
    }

    public Activity(String id, IProcessingStage stage, Optional<IProcessingStageWorkPackage> activityDemand, List<IStageTask> subTasks) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id must not be null");
        this.activityDemand = (IProcessingStageWorkPackage)activityDemand.orNull();
        this.subTasks = (List)Preconditions.checkNotNull(subTasks, (Object)"subtask list must not be null");
        this.stage = stage;
        this.overallDemand = this.calculateOverallDemand(activityDemand, subTasks);
    }

    private PositivePrimitivesMap<IResourceType> calculateOverallDemand(Optional<IProcessingStageWorkPackage> activityDemand, List<IStageTask> subTasks) {
        MutablePositivePrimitivesMap<IResourceType> sum = RmCollectionUtils.newMutablePositiveMap();
        if (activityDemand.isPresent()) {
            sum.add(((IProcessingStageWorkPackage)activityDemand.get()).getPositiveTypeAmounts());
        }
        for (IStageTask subTask : subTasks) {
            sum.add(subTask.getPositiveTypeAmounts());
        }
        return sum;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IProcessingStage getProcessingStage() {
        return this.stage;
    }

    @Override
    public float getAmount() {
        return this.overallDemand.getValueSum();
    }

    @Override
    public Set<IResourceType> getResourceTypes() {
        return this.overallDemand.keySet();
    }

    @Override
    public PositivePrimitivesMap<IResourceType> getPositiveTypeAmounts() {
        if (this.activityDemand != null) {
            return this.activityDemand.getPositiveTypeAmounts();
        }
        return RmCollectionUtils.newMutablePositiveMap();
    }

    @Override
    public List<IStageTask> getStageTasks() {
        return this.subTasks;
    }

    @Override
    public PositivePrimitivesMap<IResourceType> getOverallDemand() {
        return this.overallDemand;
    }

    public String toString() {
        return "Activity [id=" + this.id + "]";
    }

    public final int hashCode() {
        return new HashCodeBuilder().append(this.id).toHashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Activity)) {
            return false;
        }
        Activity other = (Activity)obj;
        return new EqualsBuilder().append(this.id, other.id).isEquals();
    }
}

