/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.LpAssignmentVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.LpSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentCandidate;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentCandidateSolutionImpl;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.SortableId;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
class AssignmentSolutionCreator {
    private static final Log LOGGER = Log.with(AssignmentSolutionCreator.class);

    AssignmentSolutionCreator() {
    }

    AssignmentCandidateSolutionImpl createInstance(LpSolution lpSolution, AssignmentCandidate candidate) {
        Preconditions.checkNotNull((Object)lpSolution, (Object)"lp solution must not be null");
        Preconditions.checkNotNull((Object)candidate, (Object)"solution candidate. must not be null");
        LogUtil.debug(LOGGER, "create instance for lp solution: %s", lpSolution);
        Map<String, Map<AssignmentResource, MutablePositivePrimitivesMap<SortableId>>> assignmentsMap = AssignmentSolutionCreator.createAssignmentsMap(lpSolution);
        AssignmentCandidateSolutionImpl instance = new AssignmentCandidateSolutionImpl(assignmentsMap, candidate);
        LogUtil.debug(LOGGER, "created instance: %s", instance);
        return instance;
    }

    private static Map<String, Map<AssignmentResource, MutablePositivePrimitivesMap<SortableId>>> createAssignmentsMap(LpSolution lpSolution) {
        HashMap assignmentsMap = Maps.newHashMap();
        PositivePrimitivesMap<LpAssignmentVariable> lpAssignments = lpSolution.getAssignments();
        for (LpAssignmentVariable lpVariable : lpAssignments.keySet()) {
            Map resourceMap;
            if (!assignmentsMap.containsKey(lpVariable.getStageTask())) {
                HashMap empty = Maps.newHashMap();
                assignmentsMap.put(lpVariable.getStageTask(), empty);
            }
            if (!(resourceMap = (Map)assignmentsMap.get(lpVariable.getStageTask())).containsKey(lpVariable.getResource())) {
                MutablePositivePrimitivesMap emtpy = RmCollectionUtils.newMutablePositiveMap();
                resourceMap.put(lpVariable.getResource(), emtpy);
            }
            MutablePositivePrimitivesMap loads = (MutablePositivePrimitivesMap)resourceMap.get(lpVariable.getResource());
            loads.add(lpVariable.getTypeId(), lpAssignments.get(lpVariable));
        }
        return assignmentsMap;
    }
}

