/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.plugins.jira.views;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.jira.event.mau.MauEventServiceBridge;
import com.atlassian.rm.common.bridges.jira.event.mau.MauEventServiceBridgeProxy;
import com.atlassian.rm.common.bridges.jira.license.LicenseData;
import com.atlassian.rm.common.bridges.jira.license.LicenseErrorType;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.radiantminds.plugins.jira.views.BaseMetaAwareView;
import com.radiantminds.roadmap.api.PluginPermission;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioCustomWordingPersistence;
import com.radiantminds.roadmap.common.extensions.features.FeatureExtension;
import com.radiantminds.roadmap.common.permissions.PluginPermissions;
import com.radiantminds.roadmap.common.utils.meta.MetaDataUtils;
import com.radiantminds.roadmap.jira.common.components.agile.JiraAgileAccessor;
import com.radiantminds.roadmap.jira.common.components.extension.licenses.JiraLicenseExtension;

public abstract class BaseAutheticatedRoadmapsView
extends BaseMetaAwareView {
    private static final Log LOGGER = Log.with(BaseAutheticatedRoadmapsView.class);
    private final PluginPermission.Or pluginPermissions;
    private final JiraAuthenticationContext authenticationContext;
    private final MauEventServiceBridgeProxy mauEventServiceBridgeProxy;
    private final JiraLicenseExtension jiraLicenseExtension;

    public BaseAutheticatedRoadmapsView(PluginPermission.Or pluginPermissions, JiraAuthenticationContext authenticationContext, PluginLicenseManager licenseManager, FeatureManager featureManager, FeatureExtension featureExtension, ApplicationProperties applicationProperties, PluginPermissions pluginPermissionHandler, PortfolioCustomWordingPersistence customWordingPersistence, JiraAgileAccessor agileAccessor, MetaDataUtils metaDataUtils, MauEventServiceBridgeProxy mauEventServiceBridgeProxy, JiraLicenseExtension jiraLicenseExtension) {
        super(pluginPermissionHandler, licenseManager, featureManager, featureExtension, applicationProperties, customWordingPersistence, agileAccessor, metaDataUtils);
        this.pluginPermissions = pluginPermissions;
        this.authenticationContext = authenticationContext;
        this.mauEventServiceBridgeProxy = mauEventServiceBridgeProxy;
        this.jiraLicenseExtension = jiraLicenseExtension;
    }

    protected boolean skipLicenceCheck() {
        return false;
    }

    protected boolean skipPluginLevelAuthentication() {
        return false;
    }

    protected void tagCurrentRequestForMauTrackingIfSuccessful(String actionResult) {
        if ("success".equals(actionResult)) {
            ((MauEventServiceBridge)this.mauEventServiceBridgeProxy.get()).setPortfolioApplicationForCurrentThread();
        }
    }

    public String execute() throws Exception {
        LicenseData licenseData;
        if (this.authenticationContext.getUser() == null) {
            return "permissionviolation";
        }
        if (!this.skipPluginLevelAuthentication() && !this.pluginPermissionHandler.check(this.pluginPermissions)) {
            return "permissionviolation";
        }
        if (!this.skipLicenceCheck() && !(licenseData = this.jiraLicenseExtension.getLicenseData()).isValid()) {
            LOGGER.warn(licenseData.getErrorDetails(), new Object[0]);
            if (licenseData.getErrorType() == LicenseErrorType.Unlicensed) {
                return "unlicensed";
            }
            if (licenseData.getErrorType() == LicenseErrorType.Expired) {
                return "licenseexpiration";
            }
            if (licenseData.getErrorType() == LicenseErrorType.UserMismatch) {
                return "licenseusermismatch";
            }
            if (licenseData.getErrorType() == LicenseErrorType.TypeMismatch) {
                return "licensetypemismatch";
            }
            if (licenseData.getErrorType() == LicenseErrorType.VersionMismatch) {
                return "licenseversionmismatch";
            }
            return "licenseexpiration";
        }
        return super.execute();
    }
}

