/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.rand.backlog;

import com.google.common.base.Preconditions;
import com.radiantminds.roadmap.common.data.generator.rand.backlog.IRandomizedStoryConfiguration;

public class RandomizedStoryConfiguration
implements IRandomizedStoryConfiguration {
    private final int minOverallEstimation;
    private final int maxOverallEstimation;

    protected RandomizedStoryConfiguration(int minOverallEstimation, int maxOverallEstimation) {
        this.minOverallEstimation = minOverallEstimation;
        this.maxOverallEstimation = maxOverallEstimation;
    }

    @Override
    public int getMinOverallEstimation() {
        return this.minOverallEstimation;
    }

    @Override
    public int getMaxOverallEstimation() {
        return this.maxOverallEstimation;
    }

    public static class Builder {
        private int minOverallEstimation = 1;
        private int maxOverallEstimation = 40;

        public Builder withOverallEstimationBetweeen(int minOverallEstimation, int maxOverallEstimation) {
            Preconditions.checkArgument((minOverallEstimation <= maxOverallEstimation ? 1 : 0) != 0);
            this.minOverallEstimation = minOverallEstimation;
            this.maxOverallEstimation = maxOverallEstimation;
            return this;
        }

        public RandomizedStoryConfiguration build() {
            return new RandomizedStoryConfiguration(this.minOverallEstimation, this.maxOverallEstimation);
        }
    }
}

