/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.port.legacy.modifiers;

import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.port.AOTableImportData;
import com.radiantminds.roadmap.common.data.persistence.ao.port.legacy.BaseLegacyDocumentModifier;
import com.radiantminds.roadmap.common.utils.JPOVersion;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class ReleaseEarlyStartModifier
extends BaseLegacyDocumentModifier {
    static final String DELTA = "aodeltastartdate";
    static final String START = "aofixedstartdate";

    @Override
    public JPOVersion isRelevantBeforeVersion() {
        return new JPOVersion(1, 9, 4);
    }

    @Override
    public void modify(List<AOTableImportData> importData) {
        AOTableImportData releaseData = (AOTableImportData)this.getDataFor(AORelease.class, importData).orNull();
        if (releaseData == null) {
            return;
        }
        for (Map<String, String> release : releaseData.getRows()) {
            if (!this.isOldDefault(release)) continue;
            release.put(DELTA, "0");
        }
    }

    private boolean isOldDefault(Map<String, String> release) {
        return !release.containsKey(DELTA) && !release.containsKey(START);
    }
}

