/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.extensions.analytics;

import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingAbility;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingPerson;
import com.radiantminds.roadmap.common.extensions.analytics.AnalyticsUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class PersonStatistics {
    private final Map<SchedulingPerson, Set<SchedulingAbility>> personToAbilities;

    PersonStatistics(Map<SchedulingPerson, Set<SchedulingAbility>> map) {
        this.personToAbilities = map;
    }

    static PersonStatistics create(Collection<? extends SchedulingPerson> persons) {
        HashMap map = Maps.newHashMap();
        if (persons != null) {
            for (SchedulingPerson schedulingPerson : persons) {
                if (schedulingPerson.getPersonAbilities() == null) continue;
                for (SchedulingAbility schedulingAbility : schedulingPerson.getPersonAbilities()) {
                    RmUtils.addToKeyedSets(map, schedulingPerson, schedulingAbility);
                }
            }
        }
        return new PersonStatistics(map);
    }

    long getPersonCount() {
        return AnalyticsUtil.count(this.personToAbilities.values());
    }

    double getStdDevAbilities() {
        return AnalyticsUtil.stdDev(this.personToAbilities.values());
    }

    double getAvgAbilities() {
        return AnalyticsUtil.avg(this.personToAbilities.values());
    }
}

