/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.teams.velocity;

import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.people.RestVelocitySettings;
import com.radiantminds.roadmap.common.rest.services.teams.velocity.TeamVelocityServiceHandler;
import com.radiantminds.roadmap.common.scheduling.entities.SchedulingPlanFactory;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/teams/{id}/velocity")
@Component
public class TeamVelocitySettingsService {
    private final TeamVelocityServiceHandler handler;

    @Autowired
    public TeamVelocitySettingsService(SecuredInvocationHandlerFactory handlerFactory, SchedulingPlanFactory schedulingPlanFactory, PortfolioTeamPersistence teamPersistence) {
        this.handler = handlerFactory.createProxy(TeamVelocityServiceHandler.class, new TeamVelocityServiceHandler.Impl(teamPersistence, schedulingPlanFactory), teamPersistence);
    }

    @POST
    public Response setVelocitySettings(@PathParam(value="id") String teamId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="version") Long expectedEntityVersion, RestVelocitySettings suppliedVelocitySettings) throws Exception {
        return this.handler.setVelocitySettings(EntityContext.from(teamId, expectedEntityVersion, expectedPlanVersion), suppliedVelocitySettings);
    }
}

