/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.theme;

import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioThemePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.services.common.Operation;
import javax.ws.rs.core.Response;

public class ThemeOperation
extends Operation {
    private final PortfolioWorkItemPersistence workItemPersistence;
    private final PortfolioThemePersistence themePersistence;
    private final String themeId;

    public ThemeOperation(PortfolioWorkItemPersistence workItemPersistence, PortfolioThemePersistence themePersistence, String themeId) {
        this.workItemPersistence = workItemPersistence;
        this.themePersistence = themePersistence;
        this.themeId = themeId;
    }

    @Override
    public Response preOperationChecks() throws Exception {
        if (this.themeId != null && !this.themePersistence.exists(this.themeId)) {
            return ResponseBuilder.badRequest(RestMessaging.error("invalid-theme-assignment"));
        }
        return null;
    }

    @Override
    public void performOperation(String workItemId) throws Exception {
        this.workItemPersistence.setTheme(workItemId, this.themeId);
    }
}

