/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.utils;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.common.IPercentable;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import com.radiantminds.roadmap.common.rest.entities.common.RestBulkItemResult;
import com.radiantminds.roadmap.common.rest.entities.common.RestItemResult;
import com.radiantminds.roadmap.common.rest.utils.IPercentableCallback;
import java.util.ArrayList;
import java.util.List;

public final class PercentageUtils {
    public static <TPercentable extends IPercentable, TParent, TPersistence extends IEntityPersistence<TPercentable>> void adaptToItemRemoval(TParent parent, IPercentableCallback<TPercentable, TParent, TPersistence> callback, TPersistence persistence) throws Exception {
        List<TPercentable> selfAndSiblings = callback.getSiblings(parent);
        if (selfAndSiblings.size() == 1) {
            IPercentable item = (IPercentable)selfAndSiblings.get(0);
            item.setPercentage(null);
            callback.persist(item, false, persistence);
        } else {
            PercentageUtils.adaptSiblings(parent, null, 0.0, callback, persistence, false);
        }
    }

    public static <TPercentable extends IPercentable, TParent, TPersistence extends IEntityPersistence<TPercentable>> ModificationResult adaptToItemAdd(TParent parent, TPercentable item, IPercentableCallback<TPercentable, TParent, TPersistence> callback, TPersistence persistence) throws Exception {
        return PercentageUtils.setPercentage(item, item.getPercentage(), callback, persistence, false);
    }

    public static <TPercentable extends IPercentable, TParent, TPersistence extends IEntityPersistence<TPercentable>> ModificationResult setPercentage(TPercentable item, Double percentage, IPercentableCallback<TPercentable, TParent, TPersistence> callback, TPersistence persistence) throws Exception {
        return PercentageUtils.setPercentage(item, percentage, callback, persistence, true);
    }

    private static <TPercentable extends IPercentable, TParent, TPersistence extends IEntityPersistence<TPercentable>> ModificationResult setPercentage(TPercentable item, Double percentage, IPercentableCallback<TPercentable, TParent, TPersistence> callback, TPersistence persistence, boolean incrementVersion) throws Exception {
        TParent parent;
        List<TPercentable> selfAndSiblings;
        if (percentage == null) {
            item.setPercentage(null);
            callback.persist(item, incrementVersion, persistence);
            return new ModificationResult(item);
        }
        if (percentage > 1.0) {
            percentage = 1.0;
        }
        if (percentage < 0.0) {
            percentage = 0.0;
        }
        if ((selfAndSiblings = callback.getSiblings(parent = callback.getParent(item))).size() == 1) {
            item.setPercentage(null);
            callback.persist(item, incrementVersion, persistence);
            return new ModificationResult(item);
        }
        item.setPercentage(percentage);
        callback.persist(item, incrementVersion, persistence);
        ModificationResult retVal = new ModificationResult(item);
        List<RestItemResult> itemResults = PercentageUtils.adaptSiblings(parent, item, percentage, callback, persistence, incrementVersion);
        RestBulkItemResult otherItemsResult = new RestBulkItemResult();
        otherItemsResult.addResults(itemResults);
        retVal.setData(otherItemsResult);
        return retVal;
    }

    private static <TPercentable extends IPercentable, TParent, TPersistence extends IEntityPersistence<TPercentable>> List<RestItemResult> adaptSiblings(TParent parent, TPercentable item, double initialSum, IPercentableCallback<TPercentable, TParent, TPersistence> callback, TPersistence persistence, boolean incrementVersion) throws Exception {
        if (parent == null) {
            throw new Exception("No parent set. Unable to compute percentage.");
        }
        double sum = initialSum;
        boolean hasUndefinedValue = false;
        ArrayList siblings = Lists.newArrayList();
        for (IPercentable sibling : callback.getSiblings(parent)) {
            if (item != null && sibling.getId().equals(item.getId())) continue;
            if (sibling.getPercentage() != null) {
                sum += sibling.getPercentage().doubleValue();
            } else {
                hasUndefinedValue = true;
            }
            siblings.add(sibling);
        }
        if (sum < 1.0 && !hasUndefinedValue || sum > 1.0) {
            return PercentageUtils.normalizeToAndPersist(siblings, 1.0 - initialSum, callback, persistence, incrementVersion);
        }
        return Lists.newArrayList();
    }

    private static <TPercentable extends IPercentable, TParent, TPersistence extends IEntityPersistence<TPercentable>> List<RestItemResult> normalizeToAndPersist(List<TPercentable> items, double value, IPercentableCallback<TPercentable, TParent, TPersistence> callback, TPersistence persistence, boolean incrementVersion) throws Exception {
        if (items.size() == 0) {
            return Lists.newArrayList();
        }
        ArrayList retVal = Lists.newArrayList();
        double oldSum = 0.0;
        for (IPercentable percentable : items) {
            if (percentable.getPercentage() == null) continue;
            oldSum += percentable.getPercentage().doubleValue();
        }
        if (oldSum == 0.0) {
            double itemPackage = value / (double)items.size();
            for (IPercentable item : items) {
                item.setPercentage(itemPackage);
                callback.persist(item, incrementVersion, persistence);
                retVal.add(new RestItemResult(item.getId(), new ModificationResult(item)));
            }
        } else {
            double factor = value / oldSum;
            for (IPercentable item : items) {
                if (item.getPercentage() == null) continue;
                item.setPercentage(item.getPercentage() * factor);
                callback.persist(item, incrementVersion, persistence);
                retVal.add(new RestItemResult(item.getId(), new ModificationResult(item)));
            }
        }
        return retVal;
    }
}

