/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.entities.transferables;

import com.radiantminds.roadmap.common.data.entities.plans.SchedulingConfig;
import com.radiantminds.roadmap.common.data.entities.plans.WeekdayConfiguration;
import com.radiantminds.roadmap.common.rest.entities.plans.RestWeekdayConfiguration;

public class TransferablePlanConfiguration
implements SchedulingConfig {
    private Boolean enableSprintExceededWarnings;
    private Boolean hasSprintConstraint;
    private Boolean isSyncDependeeStartEnabled;
    private Boolean strictStoryStageDivision;
    private Long minimumLoadForUnstructuredEpics;
    private Long maxAssignableResourcesPerStory;
    private String planningUnit;
    private Integer globalSprintLength;
    private Double globalDefaultVelocity;
    private Integer heuristicThreshold;
    private Double defaultStoryEstimate;
    private Double defaultEpicEstimate;
    private Double hoursPerDay;
    private RestWeekdayConfiguration weekdayConfiguration;

    TransferablePlanConfiguration(SchedulingConfig config) {
        this.enableSprintExceededWarnings = config.getSprintExceededWarn();
        this.hasSprintConstraint = config.getHasSprintConstraint();
        this.isSyncDependeeStartEnabled = config.getSyncStartEnabled();
        this.strictStoryStageDivision = config.getStrictStageDivision();
        this.minimumLoadForUnstructuredEpics = config.getMinLoadUnstrEpics();
        this.maxAssignableResourcesPerStory = config.getMaxResourcesPerStory();
        this.planningUnit = config.getPlanningUnit();
        this.globalSprintLength = config.getGlobalSprintLength();
        this.globalDefaultVelocity = config.getGlobalDefaultVelocity();
        this.heuristicThreshold = config.getHeuristicThreshold();
        this.defaultStoryEstimate = config.getDefaultStoryEstimate();
        this.defaultEpicEstimate = config.getDefaultEpicEstimate();
        this.hoursPerDay = config.getHoursPerDay();
        this.weekdayConfiguration = RestWeekdayConfiguration.fromWeekdayConfiguration(config.getWeekdayConfiguration());
    }

    @Override
    public Boolean getSprintExceededWarn() {
        return this.enableSprintExceededWarnings;
    }

    @Override
    public Boolean getHasSprintConstraint() {
        return this.hasSprintConstraint;
    }

    @Override
    public Boolean getSyncStartEnabled() {
        return this.isSyncDependeeStartEnabled;
    }

    @Override
    public Boolean getStrictStageDivision() {
        return this.strictStoryStageDivision;
    }

    @Override
    public Long getMinLoadUnstrEpics() {
        return this.minimumLoadForUnstructuredEpics;
    }

    @Override
    public Long getMaxResourcesPerStory() {
        return this.maxAssignableResourcesPerStory;
    }

    @Override
    public String getPlanningUnit() {
        return this.planningUnit;
    }

    @Override
    public Integer getHeuristicThreshold() {
        return this.heuristicThreshold;
    }

    @Override
    public Integer getGlobalSprintLength() {
        return this.globalSprintLength;
    }

    @Override
    public Double getGlobalDefaultVelocity() {
        return this.globalDefaultVelocity;
    }

    @Override
    public Double getDefaultStoryEstimate() {
        return this.defaultStoryEstimate;
    }

    @Override
    public Double getDefaultEpicEstimate() {
        return this.defaultEpicEstimate;
    }

    @Override
    public Double getHoursPerDay() {
        return this.hoursPerDay;
    }

    @Override
    public WeekdayConfiguration getWeekdayConfiguration() {
        return this.weekdayConfiguration;
    }
}

