/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.backlog;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.ITimePlan;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.EpisodeRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.StreamRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.TimePlanRestriction;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class TemporalRestrictionTransformer {
    TemporalRestrictionTransformer() {
    }

    Map<SchedulingWorkItem, TimePlanRestriction> createAssignmentRestrictions(Collection<SchedulingWorkItem> workItems, ITimePlan timePlan) {
        HashMap restrictionMap = Maps.newHashMap();
        for (SchedulingWorkItem item : workItems) {
            restrictionMap.put(item, this.transform(timePlan, item));
        }
        return restrictionMap;
    }

    TimePlanRestriction transform(ITimePlan timePlan, SchedulingWorkItem item) {
        if (item.getReleaseId() == null) {
            return new StreamRestriction(timePlan.getEpisodeStream(item.getStreamId()));
        }
        return new EpisodeRestriction(timePlan.getEpisode(item.getReleaseId()));
    }
}

