/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.analytics;

import com.atlassian.event.api.EventPublisher;
import com.radiantminds.roadmap.common.extensions.analytics.AnalyticsExtension;
import com.radiantminds.roadmap.common.extensions.analytics.PlanProperties;
import com.radiantminds.roadmap.jira.common.analytics.CalculationCancelledEvent;
import com.radiantminds.roadmap.jira.common.analytics.CalculationFinishedEvent;
import com.radiantminds.roadmap.jira.common.analytics.CalculationStartedEvent;
import com.radiantminds.roadmap.jira.common.analytics.PlanCreationEvent;
import com.radiantminds.roadmap.jira.common.analytics.ReplanningCancelledEvent;
import com.radiantminds.roadmap.jira.common.analytics.ReplanningConfirmedEvent;
import com.radiantminds.roadmap.jira.common.analytics.ReplanningInitiatedEvent;
import com.radiantminds.roadmap.jira.common.analytics.UpdateLinkedIssuesEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraAnalyticsExtension
implements AnalyticsExtension {
    private final EventPublisher eventPublisher;

    @Autowired
    public JiraAnalyticsExtension(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void publishPlanCreatedEvent(String template, String accessName, String planningUnit) {
        this.eventPublisher.publish((Object)new PlanCreationEvent(template, accessName, planningUnit));
    }

    @Override
    public void publishReplanningInitiated(Long deltaToToday) {
        this.eventPublisher.publish((Object)new ReplanningInitiatedEvent(deltaToToday));
    }

    @Override
    public void publishReplanningConfirmed(Long deltaToToday) {
        this.eventPublisher.publish((Object)new ReplanningConfirmedEvent(deltaToToday));
    }

    @Override
    public void publishReplanningCancelled(Long deltaToToday) {
        this.eventPublisher.publish((Object)new ReplanningCancelledEvent(deltaToToday));
    }

    @Override
    public void publishSyncWorkItemsEvent(Boolean syncAssignee, Boolean syncDueDate, Boolean syncEstimates, Integer itemSize) {
        this.eventPublisher.publish((Object)new UpdateLinkedIssuesEvent(syncAssignee, syncDueDate, syncEstimates, itemSize));
    }

    @Override
    public void publishCalculationStarted(String calculationId, String schedulingMode, PlanProperties planProperties) {
        this.eventPublisher.publish((Object)new CalculationStartedEvent(calculationId, schedulingMode, planProperties));
    }

    @Override
    public void publishCalculationCancelled(String calculationId, String schedulingMode, PlanProperties planProperties) {
        this.eventPublisher.publish((Object)new CalculationCancelledEvent(calculationId, schedulingMode, planProperties));
    }

    @Override
    public void publishCalculationFinished(String calculationId, String schedulingMode, PlanProperties planProperties, Long planLength, Long calculationTime, Long numberResultEntries) {
        this.eventPublisher.publish((Object)new CalculationFinishedEvent(calculationId, schedulingMode, planProperties, planLength, calculationTime, numberResultEntries));
    }
}

