/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira;

import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import java.util.HashSet;
import java.util.Set;

class PortfolioToJiraSyncConfiguration {
    private final boolean syncStories;
    private final boolean syncEpics;
    private final boolean syncInitiatives;
    private final boolean syncTitle;
    private final boolean syncDescription;
    private final boolean syncEstimates;

    private PortfolioToJiraSyncConfiguration(boolean syncStories, boolean syncEpics, boolean syncInitiatives, boolean syncTitle, boolean syncDescription, boolean syncEstimates) {
        this.syncStories = syncStories;
        this.syncEpics = syncEpics;
        this.syncInitiatives = syncInitiatives;
        this.syncTitle = syncTitle;
        this.syncDescription = syncDescription;
        this.syncEstimates = syncEstimates;
    }

    public boolean isSyncStories() {
        return this.syncStories;
    }

    public boolean isSyncEpics() {
        return this.syncEpics;
    }

    public boolean isSyncInitiatives() {
        return this.syncInitiatives;
    }

    public boolean isSyncTitle() {
        return this.syncTitle;
    }

    public boolean isSyncDescription() {
        return this.syncDescription;
    }

    public boolean isSyncEstimates() {
        return this.syncEstimates;
    }

    public Set<String> createAcceptedWorkItemTypes() {
        HashSet acceptedWorkItemTypes = Sets.newHashSet();
        if (this.isSyncStories()) {
            acceptedWorkItemTypes.add(WorkItems.Types.STORY.toString());
        }
        if (this.isSyncEpics()) {
            acceptedWorkItemTypes.add(WorkItems.Types.EPIC.toString());
        }
        if (this.isSyncInitiatives()) {
            acceptedWorkItemTypes.add(WorkItems.Types.INITIATIVE.toString());
        }
        return acceptedWorkItemTypes;
    }

    public static PortfolioToJiraSyncConfiguration fromPlanConfiguration(IPlanConfiguration planConfiguration) {
        return new PortfolioToJiraSyncConfiguration(PortfolioToJiraSyncConfiguration.isTrue(planConfiguration.getSyncStories()), PortfolioToJiraSyncConfiguration.isTrue(planConfiguration.getSyncEpics()), PortfolioToJiraSyncConfiguration.isTrue(planConfiguration.getSyncInitiatives()), PortfolioToJiraSyncConfiguration.isTrue(planConfiguration.getSyncSummary()), PortfolioToJiraSyncConfiguration.isTrue(planConfiguration.getSyncDescription()), PortfolioToJiraSyncConfiguration.isTrue(planConfiguration.getSyncEstimates()));
    }

    private static boolean isTrue(Boolean val) {
        return Boolean.TRUE.equals(val);
    }
}

