/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.customfields;

import com.atlassian.greenhopper.api.customfield.ManagedCustomFieldsService;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldNotAvailableException;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldServiceBridge;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFields;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessor;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessorProvider;
import com.atlassian.rm.common.bridges.api.plugins.access.ServiceCallback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldsServiceBridge710")
@SupportedVersions(all=true)
public class AgileCustomFieldsServiceBridge710
implements AgileCustomFieldServiceBridge {
    private static final Log LOGGER = Log.with(AgileCustomFieldsServiceBridge710.class);
    private static final String EPIC_LINK = "Epic Link";
    private static final String EPIC_LABEL = "Epic Label";
    private static final String STORY_POINTS = "Story Points";
    private static final String RANK = "Rank";
    private final BundleServiceAccessorProvider bundleServiceAccessorProvider;

    @Autowired
    public AgileCustomFieldsServiceBridge710(BundleServiceAccessorProvider bundleServiceAccessorProvider) {
        this.bundleServiceAccessorProvider = bundleServiceAccessorProvider;
    }

    @Override
    public AgileCustomFields getCustomFields() throws AgileNotAvailableException, AgileCustomFieldNotAvailableException {
        try {
            BundleServiceAccessor<ManagedCustomFieldsService> serviceAccessor = this.bundleServiceAccessorProvider.createServiceAccessor(ManagedCustomFieldsService.class);
            return serviceAccessor.perform(new ServiceCallback<ManagedCustomFieldsService, AgileCustomFields>(){

                @Override
                public AgileCustomFields perform(ManagedCustomFieldsService managedCustomFieldsService) throws AgileCustomFieldNotAvailableException {
                    return new AgileCustomFields(AgileCustomFieldsServiceBridge710.this.getEpicLabel(managedCustomFieldsService), AgileCustomFieldsServiceBridge710.this.getEpicLink(managedCustomFieldsService), AgileCustomFieldsServiceBridge710.this.getStoryPoints(managedCustomFieldsService), AgileCustomFieldsServiceBridge710.this.getRank(managedCustomFieldsService), AgileCustomFieldsServiceBridge710.this.getSprints(managedCustomFieldsService));
                }
            });
        }
        catch (AgileCustomFieldNotAvailableException customFieldException) {
            throw customFieldException;
        }
        catch (Exception e) {
            throw new AgileNotAvailableException(e);
        }
    }

    @Override
    public CustomField getRankField() throws AgileNotAvailableException, AgileCustomFieldNotAvailableException {
        try {
            BundleServiceAccessor<ManagedCustomFieldsService> serviceAccessor = this.bundleServiceAccessorProvider.createServiceAccessor(ManagedCustomFieldsService.class);
            return serviceAccessor.perform(new ServiceCallback<ManagedCustomFieldsService, CustomField>(){

                @Override
                public CustomField perform(ManagedCustomFieldsService managedCustomFieldsService) throws AgileCustomFieldNotAvailableException {
                    return AgileCustomFieldsServiceBridge710.this.getRank(managedCustomFieldsService);
                }
            });
        }
        catch (AgileCustomFieldNotAvailableException customFieldException) {
            throw customFieldException;
        }
        catch (Exception e) {
            throw new AgileNotAvailableException(e);
        }
    }

    private CustomField getEpicLink(Object managedCustomFieldsService) throws AgileCustomFieldNotAvailableException {
        try {
            return AgileCustomFieldsServiceBridge710.getCustomField(EPIC_LINK, (ServiceOutcome<CustomField>)((ManagedCustomFieldsService)managedCustomFieldsService).getEpicLinkCustomField());
        }
        catch (RuntimeException e) {
            LOGGER.exception(e);
            throw new AgileCustomFieldNotAvailableException(EPIC_LINK);
        }
    }

    private CustomField getStoryPoints(Object managedCustomFieldsService) throws AgileCustomFieldNotAvailableException {
        try {
            return AgileCustomFieldsServiceBridge710.getCustomField(STORY_POINTS, (ServiceOutcome<CustomField>)((ManagedCustomFieldsService)managedCustomFieldsService).getStoryPointsCustomField());
        }
        catch (RuntimeException e) {
            LOGGER.exception(e);
            throw new AgileCustomFieldNotAvailableException(STORY_POINTS);
        }
    }

    private CustomField getEpicLabel(Object managedCustomFieldsService) throws AgileCustomFieldNotAvailableException {
        try {
            return AgileCustomFieldsServiceBridge710.getCustomField(EPIC_LABEL, (ServiceOutcome<CustomField>)((ManagedCustomFieldsService)managedCustomFieldsService).getEpicNameCustomField());
        }
        catch (RuntimeException e) {
            LOGGER.exception(e);
            throw new AgileCustomFieldNotAvailableException(EPIC_LABEL);
        }
    }

    private CustomField getRank(Object managedCustomFieldsService) throws AgileCustomFieldNotAvailableException {
        try {
            return AgileCustomFieldsServiceBridge710.getCustomField(RANK, (ServiceOutcome<CustomField>)((ManagedCustomFieldsService)managedCustomFieldsService).getRankCustomField());
        }
        catch (RuntimeException e) {
            LOGGER.exception(e);
            throw new AgileCustomFieldNotAvailableException(RANK);
        }
    }

    private CustomField getSprints(Object managedCustomFieldsService) throws AgileCustomFieldNotAvailableException {
        try {
            return AgileCustomFieldsServiceBridge710.getCustomField("Sprint", (ServiceOutcome<CustomField>)((ManagedCustomFieldsService)managedCustomFieldsService).getSprintCustomField());
        }
        catch (RuntimeException e) {
            LOGGER.exception(e);
            throw new AgileCustomFieldNotAvailableException("Sprint");
        }
    }

    private static CustomField getCustomField(String customFieldName, ServiceOutcome<CustomField> serviceOutcome) throws AgileCustomFieldNotAvailableException {
        if (serviceOutcome.getErrorCollection() == null || !serviceOutcome.getErrorCollection().hasAnyErrors()) {
            return (CustomField)serviceOutcome.getReturnedValue();
        }
        LOGGER.error("Unavailable to retrieve custom field '" + customFieldName + "' from Agile.", new Object[0]);
        for (String message : serviceOutcome.getErrorCollection().getErrorMessages()) {
            LOGGER.error("Details: " + message, new Object[0]);
        }
        throw new AgileCustomFieldNotAvailableException(customFieldName);
    }
}

