/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.component;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.component.ProjectComponentServiceBridge;
import com.google.common.base.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.component.ProjectComponentServiceBridge710")
@SupportedVersions(all=true)
public class ProjectComponentServiceBridge710
implements ProjectComponentServiceBridge {
    private final ProjectComponentService projectComponentService;
    private final Log LOGGER = Log.with(ProjectComponentServiceBridge710.class);

    @Autowired
    ProjectComponentServiceBridge710(ProjectComponentService projectComponentService) {
        this.projectComponentService = projectComponentService;
    }

    @Override
    public long create(ApplicationUser user, long projectId, String name) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectComponent projectComponent = this.projectComponentService.create(user, (ErrorCollection)errorCollection, name, null, user.getName(), Long.valueOf(projectId), Long.valueOf(0L));
        if (errorCollection.hasAnyErrors()) {
            this.LOGGER.warn("Error while trying to create component with name %s in project %s.", name, projectId);
            this.LOGGER.warn("errors: %s", errorCollection.getErrors());
            this.LOGGER.warn("reasons: %s", errorCollection.getReasons());
        }
        return projectComponent.getId();
    }

    @Override
    public Optional<ProjectComponent> find(ApplicationUser user, long componentId) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Optional returnValue = Optional.fromNullable((Object)this.projectComponentService.find(user, (ErrorCollection)errorCollection, Long.valueOf(componentId)));
        if (errorCollection.hasAnyErrors()) {
            this.LOGGER.warn("Error while trying to find component with id %s.", componentId);
            this.LOGGER.warn("errors: %s", errorCollection.getErrors());
            this.LOGGER.warn("reasons: %s", errorCollection.getReasons());
        }
        return returnValue;
    }
}

