/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.issue;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.issue.IssueAssignmentException;
import com.atlassian.rm.common.bridges.jira.issue.IssueServiceBridge;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.issue.IssueServiceBridge710")
@SupportedVersions(maxExclusive="8.1")
public class IssueServiceBridge710
implements IssueServiceBridge {
    private final IssueService issueService;
    private final PermissionManager permissionManager;

    @Autowired
    public IssueServiceBridge710(IssueService issueService, PermissionManager permissionManager) {
        this.issueService = issueService;
        this.permissionManager = permissionManager;
    }

    @Override
    public IssueService.IssueResult getIssue(ApplicationUser user, String issueKey) {
        return this.issueService.getIssue(user, issueKey);
    }

    @Override
    public IssueService.IssueResult getIssue(@Nullable ApplicationUser user, Long issueId) {
        return this.issueService.getIssue(user, issueId);
    }

    @Override
    public IssueService.CreateValidationResult validateCreate(ApplicationUser user, IssueInputParameters issueInputParameters) {
        IssueService.CreateValidationResult validationResult = this.issueService.validateCreate(user, issueInputParameters);
        return this.checkAdditionalPermissions(user, issueInputParameters, validationResult);
    }

    @Override
    public IssueService.IssueResult create(ApplicationUser user, IssueService.CreateValidationResult createValidationResult) {
        return this.issueService.create(user, createValidationResult);
    }

    @Override
    public IssueService.DeleteValidationResult validateDelete(ApplicationUser user, Long issueId) {
        return this.issueService.validateDelete(user, issueId);
    }

    @Override
    public ErrorCollection delete(@Nullable ApplicationUser user, IssueService.DeleteValidationResult deleteValidationResult) {
        return this.issueService.delete(user, deleteValidationResult);
    }

    @Override
    public IssueService.UpdateValidationResult validateUpdate(ApplicationUser user, Long issueId, IssueInputParameters issueInputParameters) {
        IssueService.UpdateValidationResult validationResult = this.issueService.validateUpdate(user, issueId, issueInputParameters);
        return this.checkAdditionalPermissions(user, issueInputParameters, validationResult);
    }

    @Override
    public IssueService.IssueResult update(ApplicationUser user, IssueService.UpdateValidationResult updateValidationResult) {
        return this.issueService.update(user, updateValidationResult);
    }

    @Override
    public IssueService.TransitionValidationResult validateTransition(ApplicationUser user, Long issueId, int actionId, IssueInputParameters issueInputParameters) {
        return this.issueService.validateTransition(user, issueId, actionId, issueInputParameters);
    }

    @Override
    public IssueService.IssueResult transition(ApplicationUser user, IssueService.TransitionValidationResult transitionValidationResult) {
        return this.issueService.transition(user, transitionValidationResult);
    }

    @Override
    public IssueService.CreateValidationResult validateSubTaskCreate(ApplicationUser reporter, Long parentId, IssueInputParameters issueInputParameters) {
        return this.issueService.validateSubTaskCreate(reporter, parentId, issueInputParameters);
    }

    @Override
    public IssueInputParameters newIssueInputParameters() {
        return this.issueService.newIssueInputParameters();
    }

    @Override
    public IssueInputParameters newIssueInputParameters(Map<String, String[]> params) {
        return this.issueService.newIssueInputParameters(params);
    }

    @Override
    public void setAssignee(ApplicationUser user, long issueId, String assigneeId) throws IssueAssignmentException {
        IssueService.AssignValidationResult validationResult = this.issueService.validateAssign(user, Long.valueOf(issueId), assigneeId);
        if (validationResult.isValid()) {
            IssueService.IssueResult result = this.issueService.assign(user, validationResult);
            if (!result.isValid()) {
                throw new IssueAssignmentException(result.getErrorCollection());
            }
        } else {
            throw new IssueAssignmentException(validationResult.getErrorCollection());
        }
    }

    private <T extends IssueService.IssueValidationResult> T checkAdditionalPermissions(ApplicationUser user, IssueInputParameters inputParameters, T validationResult) {
        if (inputParameters.getFixVersionIds() != null && !validationResult.getErrorCollection().hasAnyErrors() && !this.permissionManager.hasPermission(ProjectPermissions.RESOLVE_ISSUES, (Issue)validationResult.getIssue(), user)) {
            validationResult.getErrorCollection().addError("fixVersions", "Resolve issue permissions required to set fix version.");
        }
        return validationResult;
    }
}

