/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.issue.fields;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.vdi.NonNullCustomFieldProvider;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.index.FieldIndexer;
import com.atlassian.rm.common.bridges.jira.index.FieldValueRetriever;
import com.atlassian.rm.common.bridges.jira.issue.fields.CustomFieldHelperBridge;
import com.atlassian.rm.common.bridges.lucene.Document33;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.document.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.issue.fields.CustomFieldHelperBridge710")
@SupportedVersions(maxExclusive="8.0")
public class CustomFieldHelperBridge710
implements CustomFieldHelperBridge {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFieldHelperBridge710.class);

    @Override
    public List<IssueType> getAssociatedIssueTypes(CustomField customField) {
        return customField.getAssociatedIssueTypes();
    }

    @Override
    public CustomFieldSearcherInformation createSearcherInformation(CustomField field, FieldIndexer fieldIndexer) {
        return new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(new FieldIndexerDelegate(fieldIndexer)), new AtomicReference<CustomField>(field));
    }

    @Override
    public NonNullCustomFieldProvider getNonNullCustomFieldProvider(String customFieldTypeKey, FieldValueRetriever retriever) {
        LOGGER.error("Request for NonNullCustomFieldProvider prior to Jira 8.12: {}", (Object)customFieldTypeKey);
        return null;
    }

    private static class FieldIndexerDelegate
    implements com.atlassian.jira.issue.index.indexers.FieldIndexer {
        private final FieldIndexer fieldIndexer;

        FieldIndexerDelegate(FieldIndexer fieldIndexer) {
            this.fieldIndexer = fieldIndexer;
        }

        public String getId() {
            return this.fieldIndexer.getId();
        }

        public String getDocumentFieldId() {
            return this.fieldIndexer.getDocumentFieldId();
        }

        public void addIndex(Document doc, Issue issue) {
            this.fieldIndexer.addIndex(new Document33(doc), issue);
        }

        public boolean isFieldVisibleAndInScope(Issue issue) {
            return this.fieldIndexer.isFieldVisibleAndInScope(issue);
        }
    }
}

