/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.scheme;

import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.scheme.SchemeEntityTypeUtilsBridge;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.stream.StreamSupport;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.scheme.SchemeEntityTypeUtilsBridge710")
@SupportedVersions(all=true)
public class SchemeEntityTypeUtilsBridge710
implements SchemeEntityTypeUtilsBridge {
    private static final long CREATE_ISSUES_PERMISSION_TYPE = 11L;
    private static final String PROJECT_ROLE_SCHEME_ENTITY_TYPE = "projectrole";
    private static final String DEVELOPERS_PROJECT_ROLE = "10001";

    @Override
    public void removeCreateIssuePermission(Iterable<SchemeEntity> entities) {
        boolean projectPermissionTypeIsInUse = this.isProjectPermissionsTypeInUse(entities);
        Iterables.removeIf(entities, entity -> {
            if (projectPermissionTypeIsInUse) {
                ProjectPermissionKey permissionKey = (ProjectPermissionKey)entity.getEntityTypeId();
                return permissionKey.equals((Object)ProjectPermissions.CREATE_ISSUES);
            }
            Long entityType = (Long)entity.getEntityTypeId();
            return entityType == 11L;
        });
    }

    @Override
    public void addCreateIssuePermissionForDevelopers(List<SchemeEntity> entities) {
        if (this.isProjectPermissionsTypeInUse(entities)) {
            entities.add(new SchemeEntity(PROJECT_ROLE_SCHEME_ENTITY_TYPE, DEVELOPERS_PROJECT_ROLE, (Object)ProjectPermissions.CREATE_ISSUES));
        } else {
            entities.add(new SchemeEntity(PROJECT_ROLE_SCHEME_ENTITY_TYPE, DEVELOPERS_PROJECT_ROLE, (Object)11L));
        }
    }

    private boolean isProjectPermissionsTypeInUse(Iterable<SchemeEntity> entities) {
        return StreamSupport.stream(entities.spliterator(), false).anyMatch(entity -> entity.getEntityTypeId() instanceof ProjectPermissionKey);
    }
}

