/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene;

import com.atlassian.rm.common.bridges.lucene.CorruptIndexException;
import com.atlassian.rm.common.bridges.lucene.Document;
import com.atlassian.rm.common.bridges.lucene.Document33;
import com.atlassian.rm.common.bridges.lucene.IndexReader;
import com.atlassian.rm.common.bridges.lucene.IndexSearcher;
import com.atlassian.rm.common.bridges.lucene.IndexSearcher33;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.MapFieldSelector;
import org.apache.lucene.util.ReaderUtil;

public class IndexReader33
implements IndexReader {
    private final org.apache.lucene.index.IndexReader indexReader;

    public IndexReader33(org.apache.lucene.index.IndexReader indexReader) {
        this.indexReader = indexReader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexReader33 that = (IndexReader33)o;
        return this.indexReader.equals(that.indexReader);
    }

    public int hashCode() {
        return this.indexReader.hashCode();
    }

    org.apache.lucene.index.IndexReader getLuceneValue() {
        return this.indexReader;
    }

    @Override
    public Document getDocument(int position) throws IOException {
        try {
            return new Document33(this.indexReader.document(position));
        }
        catch (org.apache.lucene.index.CorruptIndexException e) {
            throw new CorruptIndexException((Exception)((Object)e));
        }
    }

    @Override
    public Document getDocument(int position, List<String> fieldNames) throws IOException {
        try {
            return new Document33(this.indexReader.document(position, (FieldSelector)new MapFieldSelector(fieldNames)));
        }
        catch (org.apache.lucene.index.CorruptIndexException e) {
            throw new CorruptIndexException((Exception)((Object)e));
        }
    }

    @Override
    public IndexSearcher openSearcher() {
        return new IndexSearcher33(new org.apache.lucene.search.IndexSearcher(this.indexReader));
    }

    @Override
    public void extractAllReaders(Collection<IndexReader> collection) {
        ArrayList rawSubReaders = Lists.newArrayList();
        ReaderUtil.gatherSubReaders((List)rawSubReaders, (org.apache.lucene.index.IndexReader)this.indexReader);
        for (org.apache.lucene.index.IndexReader raw : rawSubReaders) {
            collection.add(new IndexReader33(raw));
        }
    }

    @Override
    public IndexReader extractSubReaderForDoc(int doc) {
        return new IndexReader33(ReaderUtil.subReader((int)doc, (org.apache.lucene.index.IndexReader)this.indexReader));
    }

    @Override
    public boolean isClosed() {
        return this.indexReader.getRefCount() <= 0;
    }

    @Override
    public void close() throws IOException {
        try {
            this.indexReader.close();
        }
        catch (org.apache.lucene.index.CorruptIndexException e) {
            throw new CorruptIndexException((Exception)((Object)e));
        }
    }
}

