/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene;

import com.atlassian.rm.common.bridges.lucene.NumberValueConverter;
import com.atlassian.rm.common.bridges.lucene.NumberValueConverter33;
import com.atlassian.rm.common.bridges.lucene.Query;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;

public class Query33
implements Query {
    private final org.apache.lucene.search.Query query;

    public Query33(org.apache.lucene.search.Query query) {
        this.query = query;
    }

    public org.apache.lucene.search.Query getLuceneValue() {
        return this.query;
    }

    @Override
    public Set<String> getStringValuesForParameter(String name) {
        HashSet values = Sets.newHashSet();
        HashSet terms = Sets.newHashSet();
        this.query.extractTerms((Set)terms);
        for (Term term : terms) {
            if (!term.field().equals(name)) continue;
            values.add(term.text());
        }
        return values;
    }

    @Override
    public List<Query> extractClauses() {
        if (this.query instanceof BooleanQuery) {
            List clauses = ((BooleanQuery)this.query).clauses();
            return Lists.transform((List)clauses, (Function)new Function<BooleanClause, Query>(){

                public Query apply(BooleanClause booleanClause) {
                    return new Query33(booleanClause.getQuery());
                }
            });
        }
        return Collections.singletonList(this);
    }

    @Override
    public void recursivelyExtractFieldNames(Set<String> names) {
        Query33.recursivelyExtractFieldNames(names, this.query);
    }

    private static void recursivelyExtractFieldNames(Set<String> names, org.apache.lucene.search.Query query) {
        if (query instanceof TermQuery) {
            names.add(((TermQuery)query).getTerm().field());
        } else if (query instanceof BooleanQuery) {
            for (BooleanClause clause : ((BooleanQuery)query).getClauses()) {
                Query33.recursivelyExtractFieldNames(names, clause.getQuery());
            }
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof Query33 && this.query.equals((Object)((Query33)obj).query);
    }

    public int hashCode() {
        return this.query.hashCode();
    }

    public String toString() {
        return this.query.toString();
    }

    public static class Builder
    implements Query.Builder {
        private final BooleanQuery booleanQuery = new BooleanQuery();

        @Override
        public int numClauses() {
            return this.booleanQuery.clauses().size();
        }

        @Override
        public Query.Builder addOptionalSubQuery(Query query) {
            this.booleanQuery.add(((Query33)query).getLuceneValue(), BooleanClause.Occur.SHOULD);
            return this;
        }

        @Override
        public Query.Builder addMandatorySubQuery(Query query) {
            this.booleanQuery.add(((Query33)query).getLuceneValue(), BooleanClause.Occur.MUST);
            return this;
        }

        @Override
        public Query.Builder addExcludedQuery(Query query) {
            this.booleanQuery.add(((Query33)query).getLuceneValue(), BooleanClause.Occur.MUST_NOT);
            return this;
        }

        @Override
        public Query build() {
            return new Query33((org.apache.lucene.search.Query)this.booleanQuery);
        }
    }

    public static class Factory
    implements Query.Factory {
        @Override
        public Query createMatchAllQuery() {
            return new Query33((org.apache.lucene.search.Query)new MatchAllDocsQuery());
        }

        @Override
        public Query createMatchNothingQuery() {
            return new Query33((org.apache.lucene.search.Query)new BooleanQuery());
        }

        @Override
        public Query createWildcardQuery(String name, String value) {
            return new Query33((org.apache.lucene.search.Query)new WildcardQuery(new Term(name, value)));
        }

        @Override
        public Query createTermQuery(String name, String value) {
            return new Query33((org.apache.lucene.search.Query)new TermQuery(new Term(name, value)));
        }

        @Override
        public <T> Query createDisjunctTermQuery(String termKey, Collection<T> possibleValues) {
            BooleanQuery booleanQuery = new BooleanQuery();
            for (T value : possibleValues) {
                booleanQuery.add((org.apache.lucene.search.Query)new TermQuery(new Term(termKey, value.toString())), BooleanClause.Occur.SHOULD);
            }
            return new Query33((org.apache.lucene.search.Query)booleanQuery);
        }

        @Override
        public Query createTermRangeQuery(String name, @Nullable Number lower, @Nullable Number upper, boolean includeLower, boolean includeUpper) {
            NumberValueConverter converter = new NumberValueConverter33.Factory().create();
            return new Query33((org.apache.lucene.search.Query)new TermRangeQuery(name, converter.getStringForLucene(lower), converter.getStringForLucene(upper), includeLower, includeUpper));
        }

        @Override
        public Query createNumericRangeQuery(String name, @Nullable Number lower, @Nullable Number upper, boolean includeLower, boolean includeUpper) {
            if (lower instanceof Long || upper instanceof Long) {
                return new Query33((org.apache.lucene.search.Query)NumericRangeQuery.newLongRange((String)name, (Long)((Long)lower), (Long)((Long)upper), (boolean)includeLower, (boolean)includeUpper));
            }
            throw new UnsupportedOperationException(String.format("Range query for lower=%s and upper=%s is not currently supported!", lower, upper));
        }

        @Override
        public Query createPhraseQuery() {
            return new Query33((org.apache.lucene.search.Query)new PhraseQuery());
        }

        @Override
        public Query.Builder createQueryBuilder() {
            return new Builder();
        }
    }
}

