/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.persistence;

import com.atlassian.pocketknife.api.persistence.GlobalPropertyDao;
import com.atlassian.pocketknife.api.persistence.PersistenceService;
import com.atlassian.pocketknife.spi.persistence.PocketKnifePersistenceInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GlobalPropertyDaoImpl
implements GlobalPropertyDao {
    private static final long GLOBAL_ENTITY_ID = 1L;
    private final PersistenceService persistenceService;
    private final PocketKnifePersistenceInfo pocketKnifePersistenceInfo;

    @Autowired
    public GlobalPropertyDaoImpl(PersistenceService persistenceService, PocketKnifePersistenceInfo pocketKnifePersistenceInfo) {
        this.persistenceService = persistenceService;
        this.pocketKnifePersistenceInfo = pocketKnifePersistenceInfo;
    }

    private String propertyKey() {
        return this.pocketKnifePersistenceInfo.getGlobalPropertyDaoEntityName();
    }

    @Override
    public Long getLongProperty(String key) {
        return this.persistenceService.getLong(this.propertyKey(), 1L, key);
    }

    @Override
    public void setLongProperty(String key, Long value) {
        this.persistenceService.setLong(this.propertyKey(), 1L, key, value);
    }

    @Override
    public Boolean getBooleanProperty(String key) {
        return this.persistenceService.getBoolean(this.propertyKey(), 1L, key);
    }

    @Override
    public void setBooleanProperty(String key, Boolean value) {
        this.persistenceService.setBoolean(this.propertyKey(), 1L, key, value);
    }

    @Override
    public String getTextProperty(String key) {
        return this.persistenceService.getText(this.propertyKey(), 1L, key);
    }

    @Override
    public void setTextProperty(String key, String value) {
        this.persistenceService.setText(this.propertyKey(), 1L, key, value);
    }
}

