/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.sprints;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.PageRequest;
import com.atlassian.greenhopper.service.PageRequests;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintQuery;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.greenhopper.web.rapid.chart.VelocityChartModel;
import com.atlassian.greenhopper.web.rapid.chart.VelocityChartModelFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.AgileServiceOutcomeException;
import com.atlassian.rm.common.bridges.agile.common.service.BundleServiceServiceResultHandler;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldNotAvailableException;
import com.atlassian.rm.common.bridges.agile.service.BundleServiceServiceOutcomeHandler;
import com.atlassian.rm.common.bridges.agile.service.ServiceOutcomeHandlerAction;
import com.atlassian.rm.common.bridges.agile.service.UnsafeBundleServiceServiceOutcomeHandler;
import com.atlassian.rm.common.bridges.agile.sprints.AgileSprint;
import com.atlassian.rm.common.bridges.agile.sprints.AgileSprintManagerBridge;
import com.atlassian.rm.common.bridges.agile.sprints.AgileSprintManagerBridgeProxy;
import com.atlassian.rm.common.bridges.agile.sprints.AgileSprintServiceBridge;
import com.atlassian.rm.common.bridges.agile.sprints.SprintsTransformer;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessorProvider;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.agile.sprints.AgileSprintsServiceBridge710")
@SupportedVersions(all=true)
class AgileSprintsServiceBridge710
implements AgileSprintServiceBridge {
    private static final Log LOGGER = Log.with(AgileSprintsServiceBridge710.class);
    private static final String SPRINT_SERVICE_NAME = "com.atlassian.greenhopper.service.sprint.SprintService";
    private static final String AGILE_BOARD_SERVICE_NAME = "com.atlassian.greenhopper.service.rapid.view.RapidViewService";
    private static final String VELOCITY_CHART_MODEL_FACTORY_NAME = "velocityChartModelFactory";
    private final AgileSprintManagerBridgeProxy agileSprintManagerBridgeProxy;
    private final BundleServiceServiceOutcomeHandler sprintServiceOutcomeHandler;
    private final BundleServiceServiceOutcomeHandler rapidViewServiceOutcomeHandler;
    private final BundleServiceServiceResultHandler sprintServiceResultHandler;
    private final UnsafeBundleServiceServiceOutcomeHandler velocityChartModelFactoryOutcomeHandler;

    @Autowired
    public AgileSprintsServiceBridge710(BundleServiceAccessorProvider bundleServiceAccessorProvider, AgileSprintManagerBridgeProxy agileSprintManagerBridgeProxy) {
        this.agileSprintManagerBridgeProxy = agileSprintManagerBridgeProxy;
        this.sprintServiceOutcomeHandler = new BundleServiceServiceOutcomeHandler(bundleServiceAccessorProvider, SPRINT_SERVICE_NAME);
        this.sprintServiceResultHandler = new BundleServiceServiceResultHandler(bundleServiceAccessorProvider, SPRINT_SERVICE_NAME);
        this.rapidViewServiceOutcomeHandler = new BundleServiceServiceOutcomeHandler(bundleServiceAccessorProvider, AGILE_BOARD_SERVICE_NAME);
        this.velocityChartModelFactoryOutcomeHandler = new UnsafeBundleServiceServiceOutcomeHandler(bundleServiceAccessorProvider, "com.pyxis.greenhopper.jira", VELOCITY_CHART_MODEL_FACTORY_NAME);
    }

    @Override
    public AgileSprint createSprint(final ApplicationUser applicationUser, Long boardId, AgileSprint agileSprintData, final Set<Issue> issues) throws AgileServiceOutcomeException, AgileNotAvailableException {
        final RapidView rapidView = (RapidView)this.getRapidView(applicationUser, boardId);
        final Sprint sprintData = (Sprint)SprintsTransformer.agileSprintToSprint(agileSprintData);
        return this.sprintServiceOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<SprintService, ServiceOutcome, Sprint, AgileSprint>(){

            @Override
            public ServiceOutcome getServiceOutcome(SprintService sprintService) {
                return sprintService.createSprint(applicationUser, rapidView, sprintData, issues);
            }

            @Override
            public AgileSprint getResult(Sprint sprint) {
                return SprintsTransformer.sprintToAgileSprint(sprint);
            }
        });
    }

    @Override
    public void deleteSprint(final ApplicationUser applicationUser, long sprintId) throws AgileServiceOutcomeException, AgileNotAvailableException {
        final Sprint sprint = Sprint.builder().id(Long.valueOf(sprintId)).build();
        this.sprintServiceResultHandler.perform(new BundleServiceServiceResultHandler.Action<SprintService, ServiceResult>(){

            @Override
            public ServiceResult getServiceResult(SprintService sprintService) {
                return sprintService.deleteSprint(applicationUser, sprint, null);
            }
        });
    }

    @Override
    public Optional<AgileSprint> getSprintWithoutPermissionCheck(long sprintId) throws AgileServiceOutcomeException, AgileNotAvailableException {
        AgileSprintManagerBridge agileSprintManagerBridge = (AgileSprintManagerBridge)this.agileSprintManagerBridgeProxy.get();
        return agileSprintManagerBridge.getSprintWithoutPermissionCheck(sprintId);
    }

    @Override
    public List<AgileSprint> findSprints(final ApplicationUser applicationUser, long boardId, final Set<AgileSprint.State> states) throws AgileServiceOutcomeException, AgileNotAvailableException {
        LOGGER.debug("sprint query for board: %d", boardId);
        final RapidView rapidView = (RapidView)this.getRapidView(applicationUser, boardId);
        if (!rapidView.isSprintSupportEnabled()) {
            LOGGER.debug("sprints not supported", new Object[0]);
            return Lists.newArrayList();
        }
        return this.sprintServiceOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<SprintService, ServiceOutcome, Page<Sprint>, List<AgileSprint>>(){

            @Override
            public ServiceOutcome getServiceOutcome(SprintService sprintService) {
                PageRequest request = PageRequests.all();
                SprintQuery queryObject = SprintQuery.builder().states(SprintsTransformer.transformSprintStates(states)).build();
                return sprintService.getSprints(applicationUser, rapidView, request, queryObject);
            }

            @Override
            public List<AgileSprint> getResult(Page<Sprint> sprints) {
                return SprintsTransformer.transformSprints(sprints.getValues());
            }
        });
    }

    @Override
    public List<AgileSprint> tryFindSprintsWithoutPermissionCheck(ApplicationUser user, long boardId, Set<AgileSprint.State> states) throws AgileServiceOutcomeException, AgileNotAvailableException, AgileCustomFieldNotAvailableException {
        AgileSprintManagerBridge agileSprintManagerBridge = (AgileSprintManagerBridge)this.agileSprintManagerBridgeProxy.get();
        return agileSprintManagerBridge.tryFindSprintsWithoutPermissionCheck(user, boardId, states);
    }

    @Override
    public ImmutableMap<Long, Double> getSprintVelocities(final ApplicationUser applicationUser, Long boardId) throws AgileServiceOutcomeException, AgileNotAvailableException {
        LOGGER.debug("sprint velocity query for board: %d", boardId);
        final RapidView rapidView = (RapidView)this.getRapidView(applicationUser, boardId);
        if (!rapidView.isSprintSupportEnabled()) {
            LOGGER.debug("sprints not supported", new Object[0]);
            return ImmutableMap.builder().build();
        }
        return this.velocityChartModelFactoryOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<VelocityChartModelFactory, ServiceOutcome, VelocityChartModel, ImmutableMap<Long, Double>>(){

            @Override
            public ServiceOutcome getServiceOutcome(VelocityChartModelFactory velocityChartModelFactory) {
                return velocityChartModelFactory.getVelocityChartModel(applicationUser, rapidView);
            }

            @Override
            public ImmutableMap<Long, Double> getResult(VelocityChartModel velocityChartModel) {
                HashMap<Long, Double> retVal = new HashMap<Long, Double>();
                for (Map.Entry entry : velocityChartModel.velocityStatEntries.entrySet()) {
                    Long sprintId = (Long)entry.getKey();
                    Double velocity = ((VelocityChartModel.VelocityStatEntry)entry.getValue()).completed.getValue();
                    retVal.put(sprintId, velocity);
                }
                return ImmutableMap.copyOf(retVal);
            }
        });
    }

    @Override
    public AgileSprint updateSprint(final ApplicationUser applicationUser, AgileSprint agileSprint) throws AgileServiceOutcomeException, AgileNotAvailableException {
        final Sprint sprint = (Sprint)SprintsTransformer.agileSprintToSprint(agileSprint);
        return this.sprintServiceOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<SprintService, ServiceOutcome, Sprint, AgileSprint>(){

            @Override
            public ServiceOutcome getServiceOutcome(SprintService sprintService) {
                return sprintService.updateSprint(applicationUser, sprint);
            }

            @Override
            public AgileSprint getResult(Sprint sprint2) {
                return SprintsTransformer.sprintToAgileSprint(sprint2);
            }
        });
    }

    @Override
    public void swapSprints(final ApplicationUser applicationUser, AgileSprint agileSprint1, AgileSprint agileSprint2) throws AgileServiceOutcomeException, AgileNotAvailableException {
        final Sprint sprint1 = (Sprint)SprintsTransformer.agileSprintToSprint(agileSprint1);
        final Sprint sprint2 = (Sprint)SprintsTransformer.agileSprintToSprint(agileSprint2);
        this.sprintServiceResultHandler.perform(new BundleServiceServiceResultHandler.Action<SprintService, ServiceResult>(){

            @Override
            public ServiceResult getServiceResult(SprintService sprintService) {
                return sprintService.swapSprints(applicationUser, sprint1, sprint2);
            }
        });
    }

    private Object getRapidView(final ApplicationUser applicationUser, final long boardId) throws AgileServiceOutcomeException, AgileNotAvailableException {
        return this.rapidViewServiceOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<RapidViewService, ServiceOutcome, RapidView, RapidView>(){

            @Override
            public ServiceOutcome getServiceOutcome(RapidViewService rapidViewService) {
                return rapidViewService.getRapidView(applicationUser, Long.valueOf(boardId));
            }

            @Override
            public RapidView getResult(RapidView rapidView) {
                return rapidView;
            }
        });
    }
}

