/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.issue.fields.CustomFieldUpdateBridge;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.issue.fields.CustomFieldUpdateBridge710")
@SupportedVersions(all=true)
public class CustomFieldUpdateBridge710
implements CustomFieldUpdateBridge {
    private final CustomFieldManager customFieldManager;
    private final ApplicationProperties applicationProperties;
    private final I18nHelper.BeanFactory i18nFactoryService;

    @Autowired
    public CustomFieldUpdateBridge710(CustomFieldManager customFieldManager, ApplicationProperties applicationProperties, I18nHelper.BeanFactory i18nFactoryService) {
        this.customFieldManager = customFieldManager;
        this.applicationProperties = applicationProperties;
        this.i18nFactoryService = i18nFactoryService;
    }

    @Override
    public CustomField getCustomFieldByName(String name) {
        return this.customFieldManager.getCustomFieldObjectByName(name);
    }

    @Override
    public void updateCustomFieldDescription(CustomField customField, String untranslatedDescription) {
        I18nHelper i18n = this.i18nFactoryService.getInstance(this.applicationProperties.getDefaultLocale());
        String description = i18n.getText(untranslatedDescription);
        this.customFieldManager.updateCustomField(customField.getIdAsLong(), customField.getFieldName(), description, customField.getCustomFieldSearcher());
    }

    @Override
    public void updateCustomFieldSearcherKey(CustomField customField, String searcherKey) {
        CustomFieldSearcher customFieldSearcher = this.customFieldManager.getCustomFieldSearcher(searcherKey);
        this.customFieldManager.updateCustomField(customField.getIdAsLong(), customField.getFieldName(), customField.getUntranslatedDescription(), customFieldSearcher);
    }
}

