/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.issue.search;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.query.Query;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.search.DefaultSearchResults;
import com.atlassian.rm.common.bridges.jira.search.SearchServiceBridge;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.issue.search.SearchServiceBridge80")
@SupportedVersions(minInclusive="8.0")
public class SearchServiceBridge80
implements SearchServiceBridge {
    private final Log LOGGER = Log.with(SearchServiceBridge80.class);
    private final SearchService searchService;

    @Autowired
    public SearchServiceBridge80(SearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    public com.atlassian.rm.common.bridges.jira.search.SearchResults<Issue> search(ApplicationUser searcher, Query query, PagerFilter pager) throws SearchException {
        SearchResults issueSearchResults = this.searchService.search(searcher, query, pager);
        return new DefaultSearchResults<Issue>(issueSearchResults.getResults(), issueSearchResults.getTotal());
    }

    @Override
    public SearchService.ParseResult parseQuery(ApplicationUser searcher, String query) {
        return this.searchService.parseQuery(searcher, query);
    }

    @Override
    public Set<Long> getProjectFromQuery(ApplicationUser applicationUser, Query query, boolean loadProjectsViaSearchApi, long limit) {
        return this.getProjectFromQuery((Optional<ApplicationUser>)Optional.of((Object)applicationUser), query, loadProjectsViaSearchApi, false, limit);
    }

    @Override
    public Set<Long> getProjectFromQueryWithoutPermissions(Query query, boolean loadProjectsViaSearchApi, long limit) {
        return this.getProjectFromQuery((Optional<ApplicationUser>)Optional.absent(), query, loadProjectsViaSearchApi, true, limit);
    }

    private Set<Long> getProjectFromQuery(Optional<ApplicationUser> user, Query query, boolean loadProjectsViaSearchApi, boolean overrideSecurity, long limit) {
        Preconditions.checkArgument((overrideSecurity != user.isPresent() ? 1 : 0) != 0, (Object)"override security and specific user options are mutually exclusive");
        Set<Long> projectIds = this.getProjectIdsViaQueryContext(user, query, loadProjectsViaSearchApi);
        if (projectIds.isEmpty() && loadProjectsViaSearchApi) {
            return this.getProjectIdsViaExhaustiveSearch(user, query, overrideSecurity, limit);
        }
        return projectIds;
    }

    Set<Long> getProjectIdsViaExhaustiveSearch(Optional<ApplicationUser> user, Query query, boolean overrideSecurity, long issueLimit) {
        try {
            SearchResults results;
            long start = System.currentTimeMillis();
            int max = (int)issueLimit;
            HashSet projectIds = Sets.newHashSet();
            int nextStart = 0;
            do {
                results = overrideSecurity ? this.searchService.searchOverrideSecurity((ApplicationUser)user.orNull(), query, new PagerFilter(nextStart, max)) : this.searchService.search((ApplicationUser)user.orNull(), query, new PagerFilter(nextStart, max));
                for (Issue issue : results.getResults()) {
                    projectIds.add(issue.getProjectId());
                }
                nextStart = results.getNextStart();
            } while (results.getTotal() > nextStart);
            long executionTime = System.currentTimeMillis() - start;
            if (executionTime > 1000L) {
                this.LOGGER.warn("Slow query detected. Execution time %s ms.", executionTime);
            }
            return projectIds;
        }
        catch (SearchException e) {
            this.LOGGER.errorDebug((Exception)((Object)e), "Could not retrieve grouped projectIds via searchService.", new Object[0]);
            return Sets.newHashSet();
        }
    }

    private Set<Long> getProjectIdsViaQueryContext(Optional<ApplicationUser> user, Query query, boolean loadProjectsViaSearchApi) {
        QueryContext queryContext = this.searchService.getQueryContext((ApplicationUser)user.orNull(), query);
        HashSet projectIds = Sets.newHashSet();
        for (QueryContext.ProjectIssueTypeContexts contexts : queryContext.getProjectIssueTypeContexts()) {
            if (loadProjectsViaSearchApi && contexts.getProjectContext().isAll()) {
                return Collections.emptySet();
            }
            projectIds.addAll(contexts.getProjectIdInList());
        }
        return projectIds;
    }
}

