/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.lucene;

import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.util.LuceneUtils;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.lucene.LuceneDateUtilsBridge;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.lucene.LuceneDateUtilsBridge710")
@SupportedVersions(maxExclusive="8.0")
public class LuceneDateUtilsBridge710
implements LuceneDateUtilsBridge {
    @Override
    public long luceneDateToMillis(String luceneDate) {
        LocalDate jiraDate = LuceneUtils.stringToLocalDate((String)luceneDate);
        DateTime jodaDateTime = new DateTime(jiraDate.getYear(), jiraDate.getMonth(), jiraDate.getDay(), 0, 0, DateTimeZone.UTC);
        return jodaDateTime.getMillis();
    }

    @Override
    public String millisToLuceneDate(long millis) {
        org.joda.time.LocalDate jodaDate = new org.joda.time.LocalDate(millis, DateTimeZone.UTC);
        LocalDate jiraDate = new LocalDate(jodaDate.getYear(), jodaDate.getMonthOfYear(), jodaDate.getDayOfMonth());
        return LuceneUtils.localDateToString((LocalDate)jiraDate);
    }

    @Override
    public long luceneDateTimeToMillis(String luceneDateTime) {
        return LuceneUtils.stringToDate((String)luceneDateTime).getTime();
    }

    @Override
    public String millisToLuceneDateTime(long millis) {
        return LuceneUtils.dateToString((Date)new Date(millis));
    }
}

