/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.threading;

import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.threading.JiraThreadLocalUtilsBridge;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.threading.JiraThreadLocalUtilsBridge710")
@SupportedVersions(maxExclusive="8.0")
public class JiraThreadLocalUtilsBridge710
implements JiraThreadLocalUtilsBridge {
    private static final Logger LOGGER = Logger.getLogger(JiraThreadLocalUtilsBridge710.class);

    @Override
    public void run(Runnable runnable) throws InterruptedException {
        runnable = this.wrap(runnable);
        Thread thread = new Thread(runnable);
        thread.start();
        thread.join();
    }

    private Runnable wrap(final Runnable runnable) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    JiraThreadLocalUtils.preCall();
                    try {
                        runnable.run();
                    }
                    finally {
                        JiraThreadLocalUtil.WarningCallback warningCallback = null;
                        JiraThreadLocalUtils.postCall((Logger)LOGGER, warningCallback);
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        };
    }
}

