/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene;

import com.atlassian.rm.common.bridges.lucene.Field;
import com.atlassian.rm.common.bridges.lucene.LuceneConstants;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;

public class Field33
implements Field {
    private final Fieldable fieldable;

    Field33(Fieldable fieldable) {
        this.fieldable = fieldable;
    }

    Fieldable getLuceneValue() {
        return this.fieldable;
    }

    @Override
    public String getName() {
        return this.fieldable.name();
    }

    @Override
    public String getStringValue() {
        return this.fieldable.stringValue();
    }

    public static class Factory
    implements Field.Factory {
        @Override
        public Field createTextField(String name, String value, Field.Configuration configuration) {
            Field.Store store;
            Field.Store store2 = store = configuration.isStored() ? Field.Store.YES : Field.Store.NO;
            Field.Index index = configuration.isAnalyzed() ? (configuration.isOmitNorms() ? Field.Index.ANALYZED_NO_NORMS : Field.Index.ANALYZED) : (configuration.isOmitNorms() ? Field.Index.NOT_ANALYZED_NO_NORMS : Field.Index.NOT_ANALYZED);
            return new Field33((Fieldable)new org.apache.lucene.document.Field(name, value, store, index));
        }

        @Override
        public Field createBooleanField(String name, boolean value) {
            return this.createTextField(name, LuceneConstants.valueOf(value), Field.StandardConfigurations.NOT_ANALYZED);
        }

        @Override
        public Field createNumericField(String name, long value) {
            return new Field33((Fieldable)new NumericField(name, Field.Store.YES, true).setLongValue(value));
        }

        @Override
        public Field createNumericField(String name, double value) {
            return new Field33((Fieldable)new NumericField(name, Field.Store.YES, true).setDoubleValue(value));
        }
    }
}

