/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene;

import com.atlassian.rm.common.bridges.lucene.CorruptIndexException;
import com.atlassian.rm.common.bridges.lucene.DocumentConsumer;
import com.atlassian.rm.common.bridges.lucene.IndexReader;
import com.atlassian.rm.common.bridges.lucene.IndexReader33;
import com.atlassian.rm.common.bridges.lucene.IndexSearcher;
import com.atlassian.rm.common.bridges.lucene.Query;
import com.atlassian.rm.common.bridges.lucene.Query33;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;

public class IndexSearcher33
implements IndexSearcher {
    private final org.apache.lucene.search.IndexSearcher indexSearcher;

    public IndexSearcher33(org.apache.lucene.search.IndexSearcher indexSearcher) {
        this.indexSearcher = indexSearcher;
    }

    @Override
    public void search(Query query, DocumentConsumer consumer) throws IOException {
        this.indexSearcher.search(((Query33)query).getLuceneValue(), (Collector)new CollectorDelegate(consumer));
    }

    @Override
    public void search(Query query, Query filter, DocumentConsumer consumer) throws IOException {
        this.indexSearcher.search(((Query33)query).getLuceneValue(), (Filter)new QueryWrapperFilter(((Query33)filter).getLuceneValue()), (Collector)new CollectorDelegate(consumer));
    }

    @Override
    public List<Integer> search(Query query, int limit) throws IOException {
        return this.search(query, new Query33.Factory().createMatchAllQuery(), limit);
    }

    @Override
    public List<Integer> search(Query query, Query filter, int limit) throws IOException {
        TopDocs topDocs = this.indexSearcher.search(((Query33)query).getLuceneValue(), (Filter)new QueryWrapperFilter(((Query33)filter).getLuceneValue()), limit);
        return Lists.transform(Arrays.asList(topDocs.scoreDocs), (Function)new Function<ScoreDoc, Integer>(){

            public Integer apply(ScoreDoc scoreDoc) {
                return scoreDoc.doc;
            }
        });
    }

    @Override
    public long totalHits(Query query, int limit) throws IOException {
        TopDocs topDocs = this.indexSearcher.search(((Query33)query).getLuceneValue(), limit);
        return topDocs.totalHits;
    }

    @Override
    public boolean isMatch(Query query, int documentPosition) throws IOException {
        try {
            return this.indexSearcher.explain(((Query33)query).getLuceneValue(), documentPosition).isMatch();
        }
        catch (org.apache.lucene.index.CorruptIndexException e) {
            throw new CorruptIndexException((Exception)((Object)e));
        }
    }

    @Override
    public IndexReader getIndexReader() {
        return new IndexReader33(this.indexSearcher.getIndexReader());
    }

    @Override
    public Query.Factory getQueryFactory() {
        return new Query33.Factory();
    }

    @Override
    public void close() throws IOException {
        this.indexSearcher.close();
    }

    private static class CollectorDelegate
    extends Collector {
        private final DocumentConsumer consumer;
        private IndexReader indexReader;
        private int positionBase;

        CollectorDelegate(DocumentConsumer consumer) {
            this.consumer = consumer;
        }

        public void setScorer(Scorer scorer) {
        }

        public void collect(int doc) throws IOException {
            this.consumer.consume(this.indexReader, this.positionBase, doc);
        }

        public void setNextReader(org.apache.lucene.index.IndexReader reader, int docBase) {
            this.indexReader = new IndexReader33(reader);
            this.positionBase = docBase;
        }

        public boolean acceptsDocsOutOfOrder() {
            return this.consumer.acceptsDocsOutOfOrder();
        }
    }
}

