/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene;

import com.atlassian.rm.common.bridges.lucene.CorruptIndexException;
import com.atlassian.rm.common.bridges.lucene.IndexReader;
import com.atlassian.rm.common.bridges.lucene.IndexReader33;
import com.atlassian.rm.common.bridges.lucene.IndexStore;
import com.atlassian.rm.common.bridges.lucene.IndexWriter;
import com.atlassian.rm.common.bridges.lucene.IndexWriter33;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;

public class IndexStore33
implements IndexStore {
    private final Directory directory;
    private final Analyzer analyzer;

    IndexStore33(Directory directory, Analyzer analyzer) {
        this.directory = directory;
        this.analyzer = analyzer;
    }

    @Override
    public IndexReader openReader() throws IOException {
        try {
            return new IndexReader33(org.apache.lucene.index.IndexReader.open((Directory)this.directory));
        }
        catch (org.apache.lucene.index.CorruptIndexException e) {
            throw new CorruptIndexException((Exception)((Object)e));
        }
    }

    @Override
    public IndexWriter openWriter() throws IOException {
        try {
            IndexWriterConfig writerConfig = new IndexWriterConfig(Version.LUCENE_33, this.analyzer);
            return new IndexWriter33(new org.apache.lucene.index.IndexWriter(this.directory, writerConfig));
        }
        catch (org.apache.lucene.index.CorruptIndexException e) {
            throw new CorruptIndexException((Exception)((Object)e));
        }
    }

    static {
        IndexWriterConfig.setDefaultWriteLockTimeout((long)(Lock.LOCK_POLL_INTERVAL * 2L));
    }

    public static class Factory
    implements IndexStore.Factory {
        private final Analyzer analyzer;

        public Factory(Analyzer analyzer) {
            this.analyzer = analyzer;
        }

        @Override
        public IndexStore create() {
            return new IndexStore33((Directory)new RAMDirectory(), this.analyzer);
        }
    }
}

