/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene;

import com.atlassian.rm.common.bridges.lucene.Document;
import com.atlassian.rm.common.bridges.lucene.Document33;
import com.atlassian.rm.common.bridges.lucene.IndexReader;
import com.atlassian.rm.common.bridges.lucene.IndexReader33;
import com.atlassian.rm.common.bridges.lucene.IndexSearcher;
import com.atlassian.rm.common.bridges.lucene.IndexSearcher33;
import com.atlassian.rm.common.bridges.lucene.MultiIndexReader;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.MapFieldSelector;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.util.ReaderUtil;

public class MultiIndexReader33
implements MultiIndexReader {
    private final MultiReader reader;

    public MultiIndexReader33(Collection<IndexReader> subReaders) {
        this.reader = new MultiReader(Collections2.transform(subReaders, (Function)new Function<IndexReader, org.apache.lucene.index.IndexReader>(){

            public org.apache.lucene.index.IndexReader apply(IndexReader subReader) {
                return ((IndexReader33)subReader).getLuceneValue();
            }
        }).toArray(new org.apache.lucene.index.IndexReader[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiIndexReader33 that = (MultiIndexReader33)o;
        return this.reader.equals(that.reader);
    }

    public int hashCode() {
        return this.reader.hashCode();
    }

    @Override
    public Document getDocument(int position) throws IOException {
        return new Document33(this.reader.document(position));
    }

    @Override
    public Document getDocument(int position, List<String> fieldNames) throws IOException {
        return new Document33(this.reader.document(position, (FieldSelector)new MapFieldSelector(fieldNames)));
    }

    @Override
    public IndexSearcher openSearcher() {
        return new IndexSearcher33(new org.apache.lucene.search.IndexSearcher((org.apache.lucene.index.IndexReader)this.reader));
    }

    @Override
    public void extractAllReaders(Collection<IndexReader> collection) {
        ArrayList subReaders = Lists.newArrayList();
        ReaderUtil.gatherSubReaders((List)subReaders, (org.apache.lucene.index.IndexReader)this.reader);
        for (org.apache.lucene.index.IndexReader subReader : subReaders) {
            collection.add(new IndexReader33(subReader));
        }
    }

    @Override
    public IndexReader extractSubReaderForDoc(int doc) {
        return new IndexReader33(ReaderUtil.subReader((int)doc, (org.apache.lucene.index.IndexReader)this.reader));
    }

    @Override
    public boolean isClosed() {
        return this.reader.getRefCount() <= 0;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

