/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene.collectors;

import com.atlassian.rm.common.bridges.lucene.collectors.AllDocsCollector63;
import com.atlassian.rm.common.bridges.lucene.collectors.FirstPassGroupingResult;
import com.atlassian.rm.common.bridges.lucene.collectors.GroupResult;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Scorer;

public class AllDocsSecondPassGroupCollector63
extends Collector {
    private final String groupField;
    private final List<GroupResult> groupResults;
    private final Map<String, GroupValueCollector> collectors;
    private Map<Integer, GroupValueCollector> orderedCollectors;
    private FieldCache.StringIndex index;

    public AllDocsSecondPassGroupCollector63(String groupField, FirstPassGroupingResult firstPassResult) {
        this.groupField = groupField;
        this.collectors = Maps.newLinkedHashMap();
        ImmutableList.Builder resultsBuilder = ImmutableList.builder();
        for (String group : firstPassResult.getGroups()) {
            if (group == null) continue;
            GroupValueCollector collector = new GroupValueCollector(group);
            this.collectors.put(group, collector);
            resultsBuilder.add((Object)collector);
        }
        this.groupResults = resultsBuilder.build();
    }

    public void setScorer(Scorer scorer) {
    }

    public void collect(int doc) {
        GroupValueCollector group;
        if (doc >= 0 && doc < this.index.order.length && (group = this.orderedCollectors.get(this.index.order[doc])) != null) {
            group.docsCollector.collect(doc);
        }
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.index = FieldCache.DEFAULT.getStringIndex(reader, this.groupField);
        this.orderedCollectors = Maps.newLinkedHashMap();
        for (GroupValueCollector group : this.collectors.values()) {
            group.docsCollector.setNextReader(reader, docBase);
            this.orderedCollectors.put(this.index.binarySearchLookup(group.groupKey), group);
        }
    }

    public boolean acceptsDocsOutOfOrder() {
        return false;
    }

    public List<GroupResult> getResults() {
        return this.groupResults;
    }

    private static class GroupValueCollector
    implements GroupResult {
        private final String groupKey;
        private final AllDocsCollector63 docsCollector;

        GroupValueCollector(String groupKey) {
            this.groupKey = groupKey;
            this.docsCollector = new AllDocsCollector63();
        }

        @Override
        public String getGroupKey() {
            return this.groupKey;
        }

        @Override
        public Set<Integer> getGroupDocs() {
            return this.docsCollector.getDocs();
        }

        @Override
        public int totalHits() {
            return this.docsCollector.getDocs().size();
        }
    }
}

