/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene.collectors;

import com.atlassian.rm.common.bridges.lucene.collectors.FirstPassGroupingCollector63;
import com.atlassian.rm.common.bridges.lucene.collectors.FirstPassGroupingResult;
import com.atlassian.rm.common.bridges.lucene.collectors.UnsortedFirstPassGroupingResult;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Scorer;

public class AllGroupsFirstPassGroupCollector63
extends FirstPassGroupingCollector63 {
    private final String groupField;
    private final Set<String> groupValues;
    private FieldCache.StringIndex index;

    public AllGroupsFirstPassGroupCollector63(String groupField) {
        this.groupField = groupField;
        this.groupValues = Sets.newHashSet();
    }

    public void setScorer(Scorer scorer) {
    }

    public void collect(int doc) {
        int ord;
        if (doc >= 0 && doc < this.index.order.length && (ord = this.index.order[doc]) > 0) {
            this.groupValues.add(this.index.lookup[ord]);
        }
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.index = FieldCache.DEFAULT.getStringIndex(reader, this.groupField);
    }

    public boolean acceptsDocsOutOfOrder() {
        return false;
    }

    @Override
    public FirstPassGroupingResult getResult() {
        return new UnsortedFirstPassGroupingResult(this.groupValues);
    }
}

