/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene.collectors;

import com.atlassian.rm.common.bridges.lucene.collectors.FirstPassGroupingCollector63;
import com.atlassian.rm.common.bridges.lucene.collectors.IssueIndexType;
import com.atlassian.rm.common.bridges.lucene.collectors.SortedFirstPassGroupingResult;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.ReaderUtil;

public class SortedAllGroupsFirstPassGroupCollector63
extends FirstPassGroupingCollector63 {
    private static final String UNKNOWN_SORT_FIELD_DOC_PATTERN = "__UNINDEXED_SORT_%s";
    private final String groupField;
    private final String sortField;
    private final Map<IndexReader, IssueIndexType> readerStack;
    private final Map<String, String> groupsBySort;
    private final Map<String, String> sortsByGroup;
    private final Map<String, Boolean> indexedSortsByGroup;
    private IndexReader currentReader;
    private FieldCache.StringIndex groupIndex;
    private FieldCache.StringIndex sortIndex;

    public SortedAllGroupsFirstPassGroupCollector63(String groupField, String sortField, Map<IndexReader, IssueIndexType> readerStack) {
        this.groupField = groupField;
        this.sortField = sortField;
        this.readerStack = readerStack;
        this.groupsBySort = Maps.newTreeMap();
        this.sortsByGroup = Maps.newHashMap();
        this.indexedSortsByGroup = Maps.newHashMap();
    }

    public void setScorer(Scorer scorer) {
    }

    public void collect(int doc) {
        boolean indexedSort;
        String sort;
        if (doc < 0 || doc >= this.groupIndex.order.length) {
            return;
        }
        int groupOrd = this.groupIndex.order[doc];
        if (groupOrd <= 0) {
            return;
        }
        int sortOrd = this.sortIndex.order[doc];
        if (sortOrd != 0) {
            sort = this.sortIndex.lookup[sortOrd];
            indexedSort = true;
        } else {
            sort = String.format(UNKNOWN_SORT_FIELD_DOC_PATTERN, UUID.randomUUID().toString());
            indexedSort = false;
        }
        String group = this.groupIndex.lookup[groupOrd];
        if (this.sortsByGroup.containsKey(group)) {
            if (!indexedSort) {
                return;
            }
            IssueIndexType sourceType = this.readerStack.get(ReaderUtil.subReader((int)doc, (IndexReader)this.currentReader));
            if (sourceType != IssueIndexType.SCENARIO && this.indexedSortsByGroup.get(group).booleanValue()) {
                return;
            }
            this.groupsBySort.remove(this.sortsByGroup.remove(group));
        }
        this.groupsBySort.put(sort, group);
        this.sortsByGroup.put(group, sort);
        this.indexedSortsByGroup.put(group, indexedSort);
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.currentReader = reader;
        this.groupIndex = FieldCache.DEFAULT.getStringIndex(reader, this.groupField);
        this.sortIndex = FieldCache.DEFAULT.getStringIndex(reader, this.sortField);
    }

    public boolean acceptsDocsOutOfOrder() {
        return false;
    }

    @Override
    public SortedFirstPassGroupingResult getResult() {
        return new SortedFirstPassGroupingResult(Lists.newArrayList(this.groupsBySort.values()));
    }
}

