/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.FixedSlotItemsSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.FixedSlotItemsSolutionMapImpl;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.FixedSlotWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.DefaultFixedSlotWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.PeriodAssignmentProblemTransformationResult;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period.OverbookedPeriodAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.OverbookedWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.ItemNotSchedulableViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PeriodAssignmentProblemRetransformer {
    FixedSlotItemsSolution retransform(PeriodAssignmentProblemTransformationResult transformationResult, OverbookedPeriodAssignmentSolution solution) {
        return new FixedSlotItemsSolutionMapImpl(transformationResult.getWorkSlot(), PeriodAssignmentProblemRetransformer.createFixedSlotWorkAssignments(transformationResult, solution), this.createWarnings(transformationResult, solution), this.createViolations(transformationResult, solution));
    }

    private Set<IScheduleWarning> createWarnings(PeriodAssignmentProblemTransformationResult transformationResult, OverbookedPeriodAssignmentSolution solution) {
        if (solution.isOverbooked()) {
            return PeriodAssignmentProblemRetransformer.createWarningsForAllItems(transformationResult.getProcessingItems());
        }
        return Collections.emptySet();
    }

    private static Set<IScheduleWarning> createWarningsForAllItems(Collection<IProcessingItem> items) {
        HashSet warnings = Sets.newHashSet();
        for (IProcessingItem item : items) {
            warnings.add(new OverbookedWarning(item.getId()));
        }
        return warnings;
    }

    private Set<IScheduleViolation> createViolations(PeriodAssignmentProblemTransformationResult transformationResult, OverbookedPeriodAssignmentSolution solution) {
        HashSet violations = Sets.newHashSet();
        for (int a = 0; a < solution.getActivities(); ++a) {
            if (solution.isActivityScheduled(a)) continue;
            violations.add(new ItemNotSchedulableViolation(transformationResult.getItem(a).getId()));
        }
        return violations;
    }

    private static Map<IProcessingItem, Set<FixedSlotWorkAssignment>> createFixedSlotWorkAssignments(PeriodAssignmentProblemTransformationResult transformationResult, OverbookedPeriodAssignmentSolution solution) {
        HashMap assignmentMap = Maps.newHashMapWithExpectedSize((int)solution.getActivities());
        for (int a = 0; a < solution.getActivities(); ++a) {
            for (int r = 0; r < solution.getResources(); ++r) {
                for (int s = 0; s < solution.getSkills(); ++s) {
                    if (!(solution.getAssignedWork(a, r, s) > 0.01f)) continue;
                    RmUtils.addToKeyedSets(assignmentMap, transformationResult.getItem(a), new DefaultFixedSlotWorkAssignment(transformationResult.getAssignmentId(a), transformationResult.getWorkSlot(), transformationResult.getResource(r), transformationResult.getGroup(), transformationResult.getType(s), transformationResult.getStage(s), solution.getAssignedWork(a, r, s)));
                }
            }
        }
        return assignmentMap;
    }
}

