/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.MutableAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.AssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.AbstractProcessingItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.Activity;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.AggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivity;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivitySet;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IStageTask;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.ProcessingItemType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.TimePlanRestriction;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Immutable
public class ActivitySet
extends AbstractProcessingItem
implements IActivitySet {
    private static final Log LOGGER = Log.with(ActivitySet.class);
    private final List<IActivity> activities;

    ActivitySet(String id, int priority, int releaseTime, List<IActivity> activities, IAggregatedWorkPackage workDemand, TimePlanRestriction temporalAssignmentRestriction, AssignmentRestriction assignmentRestriction, String title, String sortKey) {
        super(id, title, priority, releaseTime, workDemand, assignmentRestriction, temporalAssignmentRestriction, sortKey);
        Preconditions.checkNotNull(activities, (Object)"activities must not be null");
        this.activities = Collections.unmodifiableList(activities);
    }

    @Override
    public List<IActivity> getActivities() {
        return this.activities;
    }

    @Override
    public ProcessingItemType getProcessingItemType() {
        return ProcessingItemType.ActivitySet;
    }

    public final int hashCode() {
        return new HashCodeBuilder().append(this.id).toHashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivitySet)) {
            return false;
        }
        ActivitySet other = (ActivitySet)obj;
        return new EqualsBuilder().append(this.id, other.id).isEquals();
    }

    public static IActivitySet createInstance(String id, String title, int priority, IAggregatedWorkPackage workDemand, AssignmentRestriction assignmentRestriction, TimePlanRestriction temporalAssignmentRestriction, String sortKey, int releaseTime) {
        return ActivitySet.createInstance(id, title, priority, (Optional<IAggregatedWorkPackage>)Optional.of((Object)workDemand), assignmentRestriction, temporalAssignmentRestriction, sortKey, releaseTime, Lists.newArrayList());
    }

    public static IActivitySet createInstance(String id, String title, int priority, Optional<IAggregatedWorkPackage> directWorkDemand, AssignmentRestriction assignmentRestriction, TimePlanRestriction temporalAssignmentRestriction, String sortKey, int releaseTime, List<IStageTask> tasks) {
        LogUtil.debug(LOGGER, "create instance with id: %s", id);
        IAggregatedWorkPackage aggregatedWorkDemand = ActivitySet.aggregate(directWorkDemand, tasks);
        List<IActivity> activities = ActivitySet.createActivities(id, aggregatedWorkDemand, directWorkDemand, tasks);
        ActivitySet instance = new ActivitySet(id, priority, releaseTime, activities, aggregatedWorkDemand, temporalAssignmentRestriction, assignmentRestriction, title, sortKey);
        LogUtil.debug(LOGGER, "created instance: %s", instance);
        return instance;
    }

    private static IAggregatedWorkPackage aggregate(Optional<IAggregatedWorkPackage> directWorkDemand, List<IStageTask> tasks) {
        ArrayList workPackages = Lists.newArrayList();
        for (IStageTask task : tasks) {
            LinkedHashMap map = Maps.newLinkedHashMap();
            map.put(task.getProcessingStage(), task);
            IAggregatedWorkPackage tasksPackage = (IAggregatedWorkPackage)AggregatedWorkPackage.tryCreateInstance(map).orNull();
            if (tasksPackage == null) continue;
            workPackages.add(tasksPackage);
        }
        if (directWorkDemand.isPresent()) {
            workPackages.add(directWorkDemand.get());
        }
        return MutableAggregatedWorkPackage.createInstance(workPackages).toImmutable();
    }

    private static List<IActivity> createActivities(String id, IAggregatedWorkPackage aggregatedWorkDemand, Optional<IAggregatedWorkPackage> workDemand, List<IStageTask> tasks) {
        ArrayList activities = Lists.newArrayList();
        List<IProcessingStage> specifiedStages = aggregatedWorkDemand.getSpecifiedStages();
        for (IProcessingStage stage : specifiedStages) {
            Optional<IProcessingStageWorkPackage> activitySetStageDemands = ActivitySet.getDirectDemand(workDemand, stage);
            List<IStageTask> stageTasks = ActivitySet.getStageSubTasks(tasks, stage);
            Activity activity = new Activity(id + "-" + stage.getId(), stage, activitySetStageDemands, stageTasks);
            activities.add(activity);
        }
        return activities;
    }

    private static Optional<IProcessingStageWorkPackage> getDirectDemand(Optional<IAggregatedWorkPackage> workDemand, IProcessingStage stage) {
        if (workDemand.isPresent()) {
            return ((IAggregatedWorkPackage)workDemand.get()).getWorkPackageForStage(stage);
        }
        return Optional.absent();
    }

    private static List<IStageTask> getStageSubTasks(List<IStageTask> tasks, IProcessingStage stage) {
        ArrayList stageTasks = Lists.newArrayList();
        for (IStageTask task : tasks) {
            if (!task.getProcessingStage().equals(stage)) continue;
            stageTasks.add(task);
        }
        return stageTasks;
    }
}

