/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.google.common.primitives.Primitives;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.PathMetadataFactory;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.ArrayExpression;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.path.SimplePath;
import java.lang.reflect.AnnotatedElement;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public class ArrayPath<A, E>
extends SimpleExpression<A>
implements Path<A>,
ArrayExpression<A, E> {
    private static final long serialVersionUID = 7795049264874048226L;
    private final Class<E> componentType;
    private final PathImpl<A> pathMixin;
    @Nullable
    private volatile NumberExpression<Integer> size;

    public ArrayPath(Class<? super A> type, String variable) {
        this(type, PathMetadataFactory.forVariable(variable));
    }

    public ArrayPath(Class<? super A> type, Path<?> parent, String property) {
        this(type, PathMetadataFactory.forProperty(parent, property));
    }

    public ArrayPath(Class<? super A> type, PathMetadata<?> metadata) {
        super(new PathImpl<A>(type, metadata));
        this.pathMixin = (PathImpl)this.mixin;
        this.componentType = Primitives.wrap(type.getComponentType());
    }

    @Override
    public final <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this.pathMixin, context);
    }

    @Override
    public SimplePath<E> get(Expression<Integer> index) {
        PathMetadata<Integer> md = PathMetadataFactory.forArrayAccess(this.pathMixin, index);
        return new SimplePath<E>(this.componentType, md);
    }

    @Override
    public SimplePath<E> get(@Nonnegative int index) {
        PathMetadata<Integer> md = PathMetadataFactory.forArrayAccess(this.pathMixin, index);
        return new SimplePath<E>(this.componentType, md);
    }

    public Class<E> getElementType() {
        return this.componentType;
    }

    @Override
    public PathMetadata<?> getMetadata() {
        return this.pathMixin.getMetadata();
    }

    @Override
    public Path<?> getRoot() {
        return this.pathMixin.getRoot();
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        return this.pathMixin.getAnnotatedElement();
    }

    @Override
    public NumberExpression<Integer> size() {
        if (this.size == null) {
            this.size = NumberOperation.create(Integer.class, Ops.ARRAY_SIZE, this.pathMixin);
        }
        return this.size;
    }
}

