/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.sql;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

abstract class AOInChunkedQueryGenerator
extends AOQueryGenerator {
    private static final int IN_CHUNK_CUTOFF = 1000;

    protected AOInChunkedQueryGenerator(Connection connection, ActiveObjectsUtilities activeObjectsUtilities) throws SQLException {
        super(connection, activeObjectsUtilities);
    }

    @Override
    public AOQueryGenerator inNumeric(AOQueryGenerator.InOperandCallback operandCallback, Collection<String> values) throws SQLException {
        return this.inChunked(operandCallback, values, this.INTEGER_CALLBACK);
    }

    @Override
    public AOQueryGenerator in(AOQueryGenerator.InOperandCallback operandCallback, Collection<String> values) throws SQLException {
        return this.inChunked(operandCallback, values, this.STRING_CALLBACK);
    }

    private AOQueryGenerator inChunked(AOQueryGenerator.InOperandCallback operandCallback, Collection<String> values, AOQueryGenerator.IParameterAddCallback callback) throws SQLException {
        List<List<String>> chunks = AOInChunkedQueryGenerator.chop(Lists.newArrayList(values), 1000);
        String operand = this.getOperand(operandCallback);
        this.query.append("(");
        for (int i = 0; i < chunks.size(); ++i) {
            this.query.append(operand);
            this.query.append(" IN (");
            this.addParameterList((Collection<String>)chunks.get(i), callback);
            this.query.append(")");
            if (i >= chunks.size() - 1) continue;
            this.query.append(" OR ");
        }
        this.query.append(")");
        this.lastCol = false;
        return this;
    }

    private static List<List<String>> chop(List<String> values, int cutoff) {
        ArrayList retVal = Lists.newArrayList();
        for (int i = 0; i < values.size(); i += cutoff) {
            retVal.add(Lists.newArrayList(values.subList(i, Math.min(values.size(), i + cutoff))));
        }
        return retVal;
    }
}

