/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.common;

import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.BulkEntityContext;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.EntityIdentifier;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.services.common.Operation;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OperationExecutor {
    private final PortfolioWorkItemPersistence workItemPersistence;

    @Autowired
    public OperationExecutor(PortfolioWorkItemPersistence workItemPersistence) {
        this.workItemPersistence = workItemPersistence;
    }

    public Response execute(EntityContext<?> entityContext, Operation operation) throws Exception {
        Response preOpsCheckResponse = operation.preOperationChecks();
        if (preOpsCheckResponse != null) {
            return preOpsCheckResponse;
        }
        if (this.workItemPersistence.countChildren(entityContext.getEntityId()) > 0) {
            return ResponseBuilder.badRequest(RestMessaging.error("pre-request-check-failed"));
        }
        try {
            operation.preItemCheck(entityContext.getEntityId());
        }
        catch (Exception e) {
            return ResponseBuilder.badRequest(RestMessaging.error("pre-item-check-failed"));
        }
        operation.performOperation(entityContext.getEntityId());
        return entityContext.okForEntityUpdate();
    }

    public Response executeInBulk(BulkEntityContext<?> entityContext, Operation operation) throws Exception {
        Response preOpsCheckResponse = operation.preOperationChecks();
        if (preOpsCheckResponse != null) {
            return preOpsCheckResponse;
        }
        for (EntityIdentifier workItem : entityContext.getEntityIds()) {
            String workItemId = workItem.getId();
            if (this.workItemPersistence.countChildren(workItemId) > 0) {
                entityContext.addFail(workItemId, "pre-request-check-failed");
                continue;
            }
            try {
                operation.preItemCheck(workItemId);
            }
            catch (Exception ex) {
                entityContext.addFail(workItemId, "pre-item-check-failed");
                continue;
            }
            operation.performOperation(workItemId);
            entityContext.addSuccess(workItemId);
        }
        return entityContext.createResult();
    }
}

