/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.streams;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.data.entities.releases.IReleaseExtensionLink;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.ntom.sql.StreamToTeamSql;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AOStream;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioReleasePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtensionLinkData;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtensionsDataRetrieval;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtils;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtilsCallback;
import com.radiantminds.roadmap.common.rest.common.ToRest;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.entities.releases.RestStream;
import com.radiantminds.roadmap.common.rest.entities.releases.RestStreamCreationResult;
import com.radiantminds.roadmap.common.rest.services.streams.teams.TeamsAvailableValidator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;

public interface PlanStreamServiceHandler {
    @AuthorizedPlanReadAccess
    public Response getAllStreams(EntityContext<IPlan> var1) throws Exception;

    @AuthorizedPlanUserAccess(incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response deleteLastStream(EntityContext<IPlan> var1, Boolean var2) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response addFirstReleaseStream(EntityContext<IPlan> var1, String var2, RestStream var3) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response addStreamToPlan(EntityContext<IPlan> var1, RestStream var2) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response rankStream(EntityContext<IPlan> var1, RestRank var2) throws Exception;

    public static class Impl
    implements PlanStreamServiceHandler {
        private final PortfolioPlanPersistence planPersistence;
        private final PortfolioStreamPersistence streamPersistence;
        private final PortfolioReleasePersistence releasePersistence;
        private final ReleaseExtensionsDataRetrieval releaseDataEnrichment;
        private final TeamsAvailableValidator teamsAvailableValidator;
        private final SubCollectionUtils subCollectionUtils;
        private final StreamToTeamSql streamToTeamSql;

        public Impl(ActiveObjectsUtilities activeObjectsUtilities, PortfolioPlanPersistence planPersistence, PortfolioStreamPersistence streamPersistence, PortfolioReleasePersistence releasePersistence, PortfolioTeamPersistence teamPersistence, PortfolioWorkItemPersistence workItemPersistence, ReleaseExtensionsDataRetrieval releaseDataEnrichment, StreamToTeamSql streamToTeamSql) {
            this.planPersistence = planPersistence;
            this.streamPersistence = streamPersistence;
            this.releasePersistence = releasePersistence;
            this.teamsAvailableValidator = new TeamsAvailableValidator(teamPersistence);
            this.releaseDataEnrichment = releaseDataEnrichment;
            this.subCollectionUtils = new SubCollectionUtils(activeObjectsUtilities, workItemPersistence);
            this.streamToTeamSql = streamToTeamSql;
        }

        @Override
        public Response deleteLastStream(EntityContext<IPlan> entityContext, Boolean deleteReleases) throws Exception {
            List<IStream> streamsInPlan = this.streamPersistence.listCustomWithReleases(entityContext.getEntityId());
            this.enrichReleaseData(streamsInPlan);
            if (streamsInPlan.size() != 1) {
                return ResponseBuilder.badRequest(RestMessaging.error("more than one stream in this plan"));
            }
            IStream defaultStream = streamsInPlan.get(0);
            if (Boolean.TRUE.equals(deleteReleases)) {
                for (IRelease release : defaultStream.getReleases()) {
                    this.releasePersistence.delete(release.getId(), false);
                }
            }
            this.planPersistence.setReleaseMode(entityContext.getEntityId(), false);
            defaultStream.setTitle("Default Stream");
            defaultStream.setShortName("D");
            defaultStream.setColor("#3b7fc4");
            defaultStream = this.streamPersistence.persist(defaultStream, true);
            this.streamToTeamSql.clearTeamAssignmentsForStream(defaultStream.getId());
            return entityContext.ok(new ModificationResult(defaultStream));
        }

        private void enrichReleaseData(List<IStream> streams) throws Exception {
            Set<IRelease> releases = this.extractReleases(streams);
            Map<IRelease, Set<ReleaseExtensionLinkData>> enrichmentData = this.releaseDataEnrichment.getExtensionLinkData(releases);
            for (IRelease release : releases) {
                Set<ReleaseExtensionLinkData> linkData = enrichmentData.get(release);
                ArrayList unenrichableExtensionLinks = Lists.newArrayList();
                for (IExtensionLink uncast : release.getExtensionLinks()) {
                    IReleaseExtensionLink link = (IReleaseExtensionLink)uncast;
                    boolean enriched = false;
                    if (linkData != null) {
                        for (ReleaseExtensionLinkData linkEnrichment : linkData) {
                            if (!link.getExtensionLink().equals(linkEnrichment.getLink())) continue;
                            link.enrich(linkEnrichment);
                            enriched = true;
                            break;
                        }
                    }
                    if (enriched) continue;
                    unenrichableExtensionLinks.add(link);
                }
                for (IReleaseExtensionLink unenrichableLink : unenrichableExtensionLinks) {
                    release.removeExtensionLink(unenrichableLink);
                }
            }
        }

        private Set<IRelease> extractReleases(List<IStream> streams) {
            HashSet releases = Sets.newHashSet();
            for (IStream stream : streams) {
                releases.add(stream.getLaterRelease());
                releases.addAll(stream.getReleases());
            }
            return releases;
        }

        @Override
        public Response getAllStreams(EntityContext<IPlan> entityContext) throws Exception {
            List<IStream> streams = this.streamPersistence.listCustomWithReleases(entityContext.getEntityId());
            this.enrichReleaseData(streams);
            return entityContext.okForList(Iterables.toArray(ToRest.transferList(RestStream.class, IStream.class, streams), RestStream.class));
        }

        @Override
        public Response addFirstReleaseStream(EntityContext<IPlan> entityContext, String mode, RestStream newStream) throws Exception {
            if ("move".equals(mode)) {
                List<IStream> streamsInPlan = this.streamPersistence.listCustomWithReleases(entityContext.getEntityId());
                this.enrichReleaseData(streamsInPlan);
                if (streamsInPlan.size() != 1) {
                    return ResponseBuilder.badRequest(RestMessaging.error("Unexpected number of streams in plan ('" + streamsInPlan.size() + "')."));
                }
                this.planPersistence.setReleaseMode(entityContext.getEntityId(), true);
                IStream defaultStream = streamsInPlan.get(0);
                defaultStream.setTitle(newStream.getTitle());
                defaultStream.setShortName(newStream.getShortName());
                defaultStream.setOrderRangeIdentifier("plan-" + entityContext.getEntityId());
                defaultStream = this.streamPersistence.persist(defaultStream, true);
                return entityContext.ok(new ModificationResult(defaultStream));
            }
            if ("keep".equals(mode)) {
                this.planPersistence.setReleaseMode(entityContext.getEntityId(), true);
                return this.addStreamToPlan(entityContext, newStream);
            }
            return ResponseBuilder.badRequest(RestMessaging.error("unknown stream creation mode '" + mode + "'"));
        }

        @Override
        public Response addStreamToPlan(EntityContext<IPlan> entityContext, final RestStream newStream) throws Exception {
            return this.subCollectionUtils.handleAddEntityToCollection(entityContext, AOStream.class, "plan", newStream, new SubCollectionUtilsCallback.Adapter<IPlan, IStream, RestStream>(){

                @Override
                public Response preOperationChecks() throws Exception {
                    Optional<String> error = teamsAvailableValidator.tryGetErrorResponse((Set)MoreObjects.firstNonNull(newStream.getTeams(), (Object)Sets.newHashSet()));
                    if (error.isPresent()) {
                        return ResponseBuilder.badRequest(RestMessaging.error((String)error.get()));
                    }
                    return null;
                }

                @Override
                public void setParent(IPlan parent, IStream entity) {
                    entity.setPlan(parent);
                }

                @Override
                public IStream persist(IStream entity) throws Exception {
                    return streamPersistence.persist(entity);
                }

                @Override
                public void afterPostPersisting(RestStream restEntity, IStream entity) throws Exception {
                    if (newStream.getTeams() != null && newStream.getTeams().size() > 0) {
                        streamToTeamSql.setTeamAssignment(entity.getId(), newStream.getTeams());
                    }
                }

                @Override
                public IStream get(String id) throws Exception {
                    return (IStream)streamPersistence.get(id);
                }

                @Override
                public ModificationResult buildModificationResult(IStream stored) throws Exception {
                    return new RestStreamCreationResult(stored);
                }
            });
        }

        @Override
        public Response rankStream(EntityContext<IPlan> entityContext, RestRank rank) throws Exception {
            return this.subCollectionUtils.rankEntity(entityContext, AOStream.class, this.streamPersistence, "plan", rank);
        }
    }
}

