/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.teams;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPersonPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioResourcePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioSprintPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.people.RestPlanningMode;
import com.radiantminds.roadmap.common.rest.entities.people.RestResource;
import com.radiantminds.roadmap.common.rest.entities.people.RestSprint;
import com.radiantminds.roadmap.common.rest.entities.people.RestTeam;
import com.radiantminds.roadmap.common.rest.services.common.BaseOperationsService;
import com.radiantminds.roadmap.common.rest.services.teams.TeamServiceHandler;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/teams")
@Component
public class TeamService
extends BaseOperationsService<ITeam, RestTeam> {
    private final TeamServiceHandler handler;

    @Autowired
    public TeamService(SecuredInvocationHandlerFactory handlerFactory, ActiveObjectsUtilities activeObjectsUtilities, PortfolioPersonPersistence personPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioTeamPersistence teamPersistence, PortfolioResourcePersistence resourcePersistence, PortfolioSprintPersistence sprintPersistence, PortfolioPlanPersistence planPersistence) {
        super(RestTeam.class, teamPersistence, handlerFactory);
        this.handler = handlerFactory.createProxy(TeamServiceHandler.class, new TeamServiceHandler.Impl(activeObjectsUtilities, resourcePersistence, personPersistence, sprintPersistence, teamPersistence, workItemPersistence, planPersistence), teamPersistence);
    }

    @Override
    protected RestTeam transform(ITeam entity, boolean includeReplanningData) {
        return new RestTeam(entity);
    }

    @Override
    protected Response update(RestTeam source, ITeam target, boolean allowNull) {
        this.updateCommons(source, target, allowNull);
        if (allowNull || source.getWeeksPerSprint() != null) {
            Integer weeksPerSprint = source.getWeeksPerSprint();
            if (weeksPerSprint != null && weeksPerSprint == -1) {
                weeksPerSprint = null;
            }
            target.setWeeksPerSprint(weeksPerSprint);
        }
        if (allowNull || source.getIterationStartType() != null) {
            target.setIterationStartType(source.getIterationStartType());
        }
        return null;
    }

    @GET
    @Path(value="{id}/resources")
    public Response getAllResources(@PathParam(value="id") String teamId, @QueryParam(value="planVersion") Long expectedPlanVersion) throws Exception {
        return this.handler.getAllResources(EntityContext.from(teamId, expectedPlanVersion));
    }

    @POST
    @Path(value="{id}/resources")
    public Response addResourceToTeam(@PathParam(value="id") String teamId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestResource newResource) throws Exception {
        return this.handler.addResourceToTeam(EntityContext.from(teamId, expectedPlanVersion, clientId), newResource);
    }

    @PUT
    @Path(value="{id}/resources/rank")
    public Response rankResource(@PathParam(value="id") String teamId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestRank rank) throws Exception {
        return this.handler.rankResource(EntityContext.from(teamId, expectedPlanVersion, clientId), rank);
    }

    @GET
    @Path(value="{id}/sprints")
    public Response getAllSprints(@PathParam(value="id") String teamId, @QueryParam(value="planVersion") Long expectedPlanVersion) throws Exception {
        return this.handler.getAllSprints(EntityContext.from(teamId, expectedPlanVersion));
    }

    @POST
    @Path(value="{id}/sprints")
    public Response addSprintToTeam(@PathParam(value="id") String teamId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestSprint newSprint) throws Exception {
        return this.handler.addSprintToTeam(EntityContext.from(teamId, expectedPlanVersion, clientId), newSprint);
    }

    @PUT
    @Path(value="{id}/sprints/rank")
    public Response rankSprint(@PathParam(value="id") String teamId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestRank rank) throws Exception {
        return this.handler.rankSprint(EntityContext.from(teamId, expectedPlanVersion, clientId), rank);
    }

    @PUT
    @Path(value="{id}/planningMode")
    public Response setPlanningMode(@PathParam(value="id") String teamId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestPlanningMode planningMode) throws Exception {
        return this.handler.setPlanningMode(EntityContext.from(teamId, expectedPlanVersion, clientId), planningMode);
    }
}

