/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.filters;

import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.search.SharedEntitySearchResult;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.extensions.filters.FiltersExtension;
import com.radiantminds.roadmap.common.extensions.filters.IssueFilterDescription;
import com.radiantminds.roadmap.common.extensions.filters.IssueFilterSearchResult;
import com.radiantminds.roadmap.jira.common.components.extension.filters.JiraIssueFilterUtil;
import com.radiantminds.roadmap.jira.common.components.utils.JiraUserUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraFiltersExtension
implements FiltersExtension {
    private static final int MAX_FILTERS = 50;
    private final JiraAuthenticationContext authenticationContext;
    private final JiraIssueFilterUtil issueFilterUtil;

    @Autowired
    public JiraFiltersExtension(JiraAuthenticationContext authenticationContext, SearchRequestService searchRequestService) {
        this.authenticationContext = authenticationContext;
        this.issueFilterUtil = new JiraIssueFilterUtil(searchRequestService);
    }

    @Override
    public IssueFilterDescription getFilter(Long filterId) {
        ApplicationUser user = JiraUserUtil.getCurrentApplicationUser(this.authenticationContext);
        SearchRequest filter = this.issueFilterUtil.getFilter(user, filterId);
        if (filter != null) {
            if (JiraIssueFilterUtil.isQueryValid(filter.getQuery())) {
                return new IssueFilterDescription(filter.getId(), filter.getName(), filter.getQuery().getQueryString(), true);
            }
        }
        return null;
    }

    @Override
    public IssueFilterSearchResult listFilters(String queryString) {
        ArrayList retVal = Lists.newArrayList();
        ApplicationUser user = JiraUserUtil.getCurrentApplicationUser(this.authenticationContext);
        SharedEntitySearchResult<SearchRequest> matchingFilterResult = this.issueFilterUtil.getFilters(user, queryString, 50);
        if (matchingFilterResult != null) {
            for (SearchRequest filter : matchingFilterResult.getResults()) {
                if (!JiraIssueFilterUtil.isQueryValid(filter.getQuery())) continue;
                retVal.add(new IssueFilterDescription(filter.getId(), filter.getName(), filter.getQuery().getQueryString(), false));
            }
            return new IssueFilterSearchResult(matchingFilterResult.getTotalResultCount(), retVal);
        }
        return new IssueFilterSearchResult(0, Collections.EMPTY_LIST);
    }
}

