/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldNotAvailableException;
import com.radiantminds.roadmap.common.data.entities.plans.TrackerType;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressConfiguration;
import com.radiantminds.roadmap.jira.common.components.agile.JiraAgileAccessor;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.HierarchicalJiraIssueData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.FailSafeCustomFieldReader;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.FullProgressCalculator;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.NoProgressProgressHandler;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.ProgressException;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.ResolutionBasedFullProgressExtractor;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.ResolutionBasedStoryPointFullProgressCalculator;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.TimeBasedFullProgressCalculator;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.TimeWeightedStoryPointFullProgressCalculator;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.UnweightedFieldFullProgressCalculator;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFields;

public class FullProgressCalculatorFactory {
    private static final Log LOGGER = Log.with(FullProgressCalculatorFactory.class);

    public static FullProgressCalculator create(HierarchicalJiraIssueData issueHierarchy, ProgressConfiguration progressConfiguration, JiraAgileAccessor agileAccessor, CustomFields customFields) throws ProgressException {
        TrackerType progressTrackerType = progressConfiguration.getTrackerType();
        switch (progressTrackerType) {
            case StoryPoints: {
                if (agileAccessor.isUsable()) {
                    try {
                        FailSafeCustomFieldReader storyPointReader = FailSafeCustomFieldReader.createStoryPointReader(customFields, issueHierarchy.getIssuesByKey());
                        String storyPointSubTaskMode = progressConfiguration.getStoryPointSubTaskMode();
                        if ("none".equals(storyPointSubTaskMode)) {
                            return new UnweightedFieldFullProgressCalculator(storyPointReader, issueHierarchy);
                        }
                        if ("time".equals(storyPointSubTaskMode)) {
                            return TimeWeightedStoryPointFullProgressCalculator.createInstance(storyPointReader, issueHierarchy);
                        }
                        return ResolutionBasedStoryPointFullProgressCalculator.createInstance(storyPointReader, issueHierarchy);
                    }
                    catch (AgileNotAvailableException e) {
                        LOGGER.error("Agile must be available for story point progress tracking", new Object[0]);
                        throw new ProgressException("Jira Agile is not available");
                    }
                    catch (AgileCustomFieldNotAvailableException e) {
                        LOGGER.error("Custom field must be available for story point progress tracking", new Object[0]);
                        throw new ProgressException("Custom field is not available");
                    }
                }
                return new NoProgressProgressHandler();
            }
            case ResolvedCount: {
                return new ResolutionBasedFullProgressExtractor(issueHierarchy);
            }
            case TimeBased: {
                boolean doneIfDone = Boolean.TRUE.equals(progressConfiguration.isCompleteIfResolved());
                return new TimeBasedFullProgressCalculator(issueHierarchy, doneIfDone);
            }
            case Manual: {
                throw new IllegalArgumentException("Field-based progress is not available.");
            }
        }
        throw new ProgressException("no available progress tracker");
    }
}

