/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.boards;

import com.atlassian.greenhopper.manager.rapidview.RapidViewManager;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.WorkingDaysConfig;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.PageRequest;
import com.atlassian.greenhopper.service.PageRequests;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.rapid.view.RapidViewQuery;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.workingdays.WorkingDaysService;
import com.atlassian.greenhopper.web.rapid.view.RapidViewPreset;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.AgileServiceOutcomeException;
import com.atlassian.rm.common.bridges.agile.boards.AgileBoard;
import com.atlassian.rm.common.bridges.agile.boards.AgileBoardServiceBridge;
import com.atlassian.rm.common.bridges.agile.boards.DefaultAgileBoard;
import com.atlassian.rm.common.bridges.agile.common.service.BundleServiceServiceResultHandler;
import com.atlassian.rm.common.bridges.agile.common.service.UnsafeBundleServiceServiceResultHandler;
import com.atlassian.rm.common.bridges.agile.service.BundleServiceServiceOutcomeHandler;
import com.atlassian.rm.common.bridges.agile.service.ServiceOutcomeHandlerAction;
import com.atlassian.rm.common.bridges.agile.service.UnsafeBundleServiceServiceOutcomeHandler;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessorProvider;
import com.google.common.base.Optional;
import java.util.List;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.agile.boards.AgileBoardServiceBridge710")
@SupportedVersions(all=true)
public class AgileBoardServiceBridge710
implements AgileBoardServiceBridge {
    private static final String RAPID_VIEW_SERVICE_NAME = "com.atlassian.greenhopper.service.rapid.view.RapidViewService";
    private static final String RAPID_VIEW_MANAGER_COMPONENT_NAME = "rapidViewManagerImpl";
    private static final String WORKING_DAYS_SERVICE_NAME = "workingDaysServiceImpl";
    private static final String RAPID_VIEW_NOT_FOUND_ERROR_KEY = "gh.rapid.view.error.noview";
    private final BundleServiceServiceResultHandler rapidViewServiceServiceResultHandler;
    private final BundleServiceServiceOutcomeHandler rapidViewServiceServiceOutcomeHandler;
    private final UnsafeBundleServiceServiceOutcomeHandler rapidViewManagerServiceOutcomeHandler;
    private final UnsafeBundleServiceServiceResultHandler workingDaysServiceServiceResultHandler;
    private final UnsafeBundleServiceServiceOutcomeHandler workingDaysServiceServiceOutcomeHandler;

    @Autowired
    public AgileBoardServiceBridge710(BundleServiceAccessorProvider bundleServiceAccessorProvider) {
        this.rapidViewServiceServiceOutcomeHandler = new BundleServiceServiceOutcomeHandler(bundleServiceAccessorProvider, RAPID_VIEW_SERVICE_NAME);
        this.rapidViewServiceServiceResultHandler = new BundleServiceServiceResultHandler(bundleServiceAccessorProvider, RAPID_VIEW_SERVICE_NAME);
        this.rapidViewManagerServiceOutcomeHandler = new UnsafeBundleServiceServiceOutcomeHandler(bundleServiceAccessorProvider, "com.pyxis.greenhopper.jira", RAPID_VIEW_MANAGER_COMPONENT_NAME);
        this.workingDaysServiceServiceResultHandler = new UnsafeBundleServiceServiceResultHandler(bundleServiceAccessorProvider, "com.pyxis.greenhopper.jira", WORKING_DAYS_SERVICE_NAME);
        this.workingDaysServiceServiceOutcomeHandler = new UnsafeBundleServiceServiceOutcomeHandler(bundleServiceAccessorProvider, "com.pyxis.greenhopper.jira", WORKING_DAYS_SERVICE_NAME);
    }

    @Override
    public AgileBoard createAgileBoard(final ApplicationUser applicationUser, final String name, final Long filterId, final AgileBoard.Type type) throws AgileServiceOutcomeException, AgileNotAvailableException {
        return this.rapidViewServiceServiceOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<RapidViewService, ServiceOutcome, RapidView, AgileBoard>(){

            @Override
            public ServiceOutcome getServiceOutcome(RapidViewService rapidViewService) {
                return rapidViewService.create(applicationUser, name, filterId, (RapidViewPreset)AgileBoardServiceBridge710.this.getRapidViewPreset(type));
            }

            @Override
            public AgileBoard getResult(RapidView rapidView) {
                return new DefaultAgileBoard(rapidView.getId(), rapidView.getName(), rapidView.getSavedFilterId(), AgileBoardServiceBridge710.this.getAgileBoardType(rapidView));
            }
        });
    }

    @Override
    public void deleteAgileBoard(final ApplicationUser applicationUser, long boardId) throws AgileServiceOutcomeException, AgileNotAvailableException {
        RapidView.RapidViewBuilder builder = new RapidView.RapidViewBuilder();
        final RapidView rapidView = builder.id(Long.valueOf(boardId)).build();
        this.rapidViewServiceServiceResultHandler.perform(new BundleServiceServiceResultHandler.Action<RapidViewService, ServiceResult>(){

            @Override
            public ServiceResult getServiceResult(RapidViewService rapidViewService) {
                return rapidViewService.delete(applicationUser, rapidView);
            }
        });
    }

    @Override
    public Optional<AgileBoard> getAgileBoard(final ApplicationUser applicationUser, final long boardId) throws AgileServiceOutcomeException, AgileNotAvailableException {
        return this.rapidViewServiceServiceOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<RapidViewService, ServiceOutcome, RapidView, Optional<AgileBoard>>(){

            @Override
            public ServiceOutcome getServiceOutcome(RapidViewService rapidViewService) {
                return rapidViewService.getRapidView(applicationUser, Long.valueOf(boardId));
            }

            @Override
            public Optional<AgileBoard> getResult(RapidView rapidView) {
                DefaultAgileBoard board = new DefaultAgileBoard(rapidView.getId(), rapidView.getName(), rapidView.getSavedFilterId(), AgileBoardServiceBridge710.this.getAgileBoardType(rapidView));
                return Optional.of((Object)board);
            }

            @Override
            public Optional<AgileBoard> handleErrors(ServiceOutcome serviceOutcome) throws AgileServiceOutcomeException {
                if (this.hasSingleError(serviceOutcome, AgileBoardServiceBridge710.RAPID_VIEW_NOT_FOUND_ERROR_KEY)) {
                    return Optional.absent();
                }
                return (Optional)super.handleErrors(serviceOutcome);
            }
        });
    }

    @Override
    public Optional<AgileBoard> getAgileBoardWithoutPermissionCheck(final long boardId) throws AgileServiceOutcomeException, AgileNotAvailableException {
        return this.rapidViewManagerServiceOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<RapidViewManager, ServiceOutcome, RapidView, Optional<AgileBoard>>(){

            @Override
            public ServiceOutcome getServiceOutcome(RapidViewManager rapidViewManager) {
                return rapidViewManager.get(Long.valueOf(boardId));
            }

            @Override
            public Optional<AgileBoard> getResult(RapidView rapidView) {
                DefaultAgileBoard board = new DefaultAgileBoard(rapidView.getId(), rapidView.getName(), rapidView.getSavedFilterId(), AgileBoardServiceBridge710.this.getAgileBoardType(rapidView));
                return Optional.of((Object)board);
            }

            @Override
            public Optional<AgileBoard> handleErrors(ServiceOutcome serviceOutcome) throws AgileServiceOutcomeException {
                if (this.hasSingleError(serviceOutcome, AgileBoardServiceBridge710.RAPID_VIEW_NOT_FOUND_ERROR_KEY)) {
                    return Optional.absent();
                }
                return (Optional)super.handleErrors(serviceOutcome);
            }
        });
    }

    @Override
    public List<AgileBoard> findAgileBoards(final ApplicationUser applicationUser, final String query) throws AgileServiceOutcomeException, AgileNotAvailableException {
        return this.rapidViewServiceServiceOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<RapidViewService, ServiceOutcome, Page<RapidView>, List<AgileBoard>>(){

            @Override
            public ServiceOutcome getServiceOutcome(RapidViewService rapidViewService) {
                PageRequest request = PageRequests.request((Long)0L, (Integer)50);
                RapidViewQuery queryObject = new RapidViewQuery.Builder().partialName(query).build();
                return rapidViewService.getRapidViews(applicationUser, request, queryObject);
            }

            @Override
            public List<AgileBoard> getResult(Page<RapidView> rapidViews) {
                return rapidViews.getValues().stream().map(new Function<RapidView, DefaultAgileBoard>(){

                    @Override
                    public DefaultAgileBoard apply(RapidView rapidView) {
                        return new DefaultAgileBoard(rapidView.getId(), rapidView.getName(), rapidView.getSavedFilterId(), AgileBoardServiceBridge710.this.getAgileBoardType(rapidView));
                    }
                }).collect(Collectors.toList());
            }
        });
    }

    @Override
    public void setTimeZone(final ApplicationUser applicationUser, long boardId, final TimeZone timeZone) throws AgileServiceOutcomeException, AgileNotAvailableException {
        Optional<WorkingDaysConfig> workingDaysConfig;
        final Optional<RapidView> rapidView = this.getRapidView(applicationUser, boardId);
        if (rapidView.isPresent() && (workingDaysConfig = this.getWorkingDaysConfig(applicationUser, boardId)).isPresent()) {
            this.workingDaysServiceServiceResultHandler.perform(new UnsafeBundleServiceServiceResultHandler.Action<WorkingDaysService, ServiceResult>(){

                @Override
                public ServiceResult getServiceResult(WorkingDaysService workingDaysService) {
                    return workingDaysService.updateWorkingDaysConfiguration(applicationUser, (RapidView)rapidView.get(), WorkingDaysConfig.builder((WorkingDaysConfig)((WorkingDaysConfig)workingDaysConfig.get())).timezoneId(timeZone.getID()).build());
                }
            });
        }
    }

    @Override
    public Optional<TimeZone> getTimeZone(ApplicationUser user, long boardId) throws AgileServiceOutcomeException, AgileNotAvailableException {
        Optional<WorkingDaysConfig> workingDaysConfig = this.getWorkingDaysConfig(user, boardId);
        if (workingDaysConfig.isPresent()) {
            return Optional.of((Object)TimeZone.getTimeZone(((WorkingDaysConfig)workingDaysConfig.get()).getTimezoneId()));
        }
        return Optional.absent();
    }

    private Optional<WorkingDaysConfig> getWorkingDaysConfig(final ApplicationUser applicationUser, long boardId) throws AgileServiceOutcomeException, AgileNotAvailableException {
        final Optional<RapidView> rapidView = this.getRapidView(applicationUser, boardId);
        if (rapidView.isPresent()) {
            return this.workingDaysServiceServiceOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<WorkingDaysService, ServiceOutcome, WorkingDaysConfig, Optional<WorkingDaysConfig>>(){

                @Override
                public ServiceOutcome getServiceOutcome(WorkingDaysService service) {
                    return service.getWorkingDaysConfiguration(applicationUser, (RapidView)rapidView.get());
                }

                @Override
                public Optional<WorkingDaysConfig> getResult(WorkingDaysConfig workingDaysConfig) {
                    return Optional.fromNullable((Object)workingDaysConfig);
                }

                @Override
                public Optional<WorkingDaysConfig> handleErrors(ServiceOutcome serviceOutcome) throws AgileServiceOutcomeException {
                    return (Optional)super.handleErrors(serviceOutcome);
                }
            });
        }
        return Optional.absent();
    }

    private Optional<RapidView> getRapidView(final ApplicationUser applicationUser, final long boardId) throws AgileServiceOutcomeException, AgileNotAvailableException {
        return this.rapidViewServiceServiceOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<RapidViewService, ServiceOutcome, RapidView, Optional<RapidView>>(){

            @Override
            public ServiceOutcome getServiceOutcome(RapidViewService rapidViewService) {
                return rapidViewService.getRapidView(applicationUser, Long.valueOf(boardId));
            }

            @Override
            public Optional<RapidView> getResult(RapidView rapidView) {
                return Optional.fromNullable((Object)rapidView);
            }

            @Override
            public Optional<RapidView> handleErrors(ServiceOutcome serviceOutcome) throws AgileServiceOutcomeException {
                if (this.hasSingleError(serviceOutcome, AgileBoardServiceBridge710.RAPID_VIEW_NOT_FOUND_ERROR_KEY)) {
                    return Optional.absent();
                }
                return (Optional)super.handleErrors(serviceOutcome);
            }
        });
    }

    private Object getRapidViewPreset(AgileBoard.Type type) {
        switch (type) {
            case SCRUM: {
                return RapidViewPreset.SCRUM;
            }
            case KANBAN: {
                return RapidViewPreset.KANBAN;
            }
        }
        throw new IllegalArgumentException("Unknown AgileBoard.Type " + (Object)((Object)type));
    }

    private AgileBoard.Type getAgileBoardType(Object rapidView) {
        switch (((RapidView)rapidView).getType()) {
            case SCRUM: {
                return AgileBoard.Type.SCRUM;
            }
            case KANBAN: {
                return AgileBoard.Type.KANBAN;
            }
        }
        throw new IllegalArgumentException("Unknown RapidView type: " + ((RapidView)rapidView).getType());
    }
}

