/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.sprints;

import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.rm.common.bridges.agile.sprints.AgileSprint;
import com.atlassian.rm.common.bridges.agile.sprints.DefaultAgileSprint;
import com.google.common.base.Optional;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class SprintsTransformer {
    public static Set transformSprintStates(Set<AgileSprint.State> states) {
        return states.stream().map(new Function<AgileSprint.State, Sprint.State>(){

            @Override
            public Sprint.State apply(AgileSprint.State input) {
                return (Sprint.State)SprintsTransformer.transformSprintState(input);
            }
        }).collect(Collectors.toSet());
    }

    public static List<AgileSprint> transformSprints(Collection sprints) {
        return sprints.stream().map(SprintsTransformer::sprintToAgileSprint).collect(Collectors.toList());
    }

    public static AgileSprint sprintToAgileSprint(@Nullable Object sprintAsObject) {
        if (sprintAsObject == null) {
            return null;
        }
        Sprint sprint = (Sprint)sprintAsObject;
        return new DefaultAgileSprint.Builder().id(sprint.getId()).name(sprint.getName()).agileBoardId(sprint.getRapidViewId()).state(SprintsTransformer.transformSprintState(sprint.getState())).sequence(sprint.getSequence()).startDate((Optional<DateTime>)Optional.fromNullable((Object)sprint.getStartDate())).endDate((Optional<DateTime>)Optional.fromNullable((Object)sprint.getEndDate())).completeDate((Optional<DateTime>)Optional.fromNullable((Object)sprint.getCompleteDate())).goal((Optional<String>)Optional.fromNullable((Object)sprint.getGoal())).build();
    }

    public static Object agileSprintToSprint(AgileSprint agileSprint) {
        Sprint.State state = (Sprint.State)SprintsTransformer.transformSprintState(agileSprint.getState());
        return Sprint.builder().id(Long.valueOf(agileSprint.getId())).name(agileSprint.getName()).rapidViewId((Long)agileSprint.getAgileBoardId().orNull()).state(state).sequence((Long)agileSprint.getSequence().orNull()).startDate((DateTime)agileSprint.getStartDateTime().orNull()).endDate((DateTime)agileSprint.getEndDateTime().orNull()).completeDate((DateTime)agileSprint.getCompleteDateTime().orNull()).goal((String)agileSprint.getGoal().orNull()).build();
    }

    public static AgileSprint.State transformSprintState(Object stateAsObject) {
        return AgileSprint.State.valueOf(stateAsObject.toString());
    }

    private static Object transformSprintState(AgileSprint.State agileState) {
        return Sprint.State.valueOf((String)agileState.toString());
    }
}

