/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.lucene;

import com.atlassian.jira.issue.search.parameters.lucene.PermissionsFilterGenerator;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.lucene.JiraLuceneQueryUtilities;
import com.atlassian.rm.common.bridges.lucene.Query;
import com.atlassian.rm.common.bridges.lucene.Query33;
import java.util.Collection;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.lucene.JiraLuceneQueryUtilities710")
@SupportedVersions(maxExclusive="8.0")
public class JiraLuceneQueryUtilities710
implements JiraLuceneQueryUtilities {
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionsFilterGenerator filterGenerator;
    private final ProjectManager projectManager;

    @Autowired
    public JiraLuceneQueryUtilities710(JiraAuthenticationContext authenticationContext, PermissionsFilterGenerator filterGenerator, ProjectManager projectManager) {
        this.authenticationContext = authenticationContext;
        this.filterGenerator = filterGenerator;
        this.projectManager = projectManager;
    }

    @Override
    public boolean isProjectPermissionQueryParsable() {
        return true;
    }

    @Override
    public boolean isRestrictedPermissionQueryNativelySupported() {
        return true;
    }

    @Override
    public Query getProjectPermissionQueryForCurrentUser() {
        return new Query33(this.filterGenerator.getQuery(this.authenticationContext.getLoggedInUser()));
    }

    @Override
    public Query getProjectPermissionQueryForCurrentUser(Set<Long> relevantProjectIds) {
        return new Query33(this.filterGenerator.getQuery(this.authenticationContext.getLoggedInUser(), (Collection)this.projectManager.convertToProjectObjects(relevantProjectIds)));
    }
}

