/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.lucene;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.jql.query.LuceneQueryBuilder;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryCreationContextImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.lucene.LuceneQueryBuilderBridge;
import com.atlassian.rm.common.bridges.lucene.Query;
import com.atlassian.rm.common.bridges.lucene.Query33;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.lucene.LuceneQueryBuilderBridge710")
@SupportedVersions(maxExclusive="8.0")
public class LuceneQueryBuilderBridge710
implements LuceneQueryBuilderBridge {
    private final JiraAuthenticationContext authenticationContext;
    private final LuceneQueryBuilder luceneQueryBuilder;

    @Autowired
    public LuceneQueryBuilderBridge710(JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
        this.luceneQueryBuilder = (LuceneQueryBuilder)ComponentAccessor.getComponent(LuceneQueryBuilder.class);
    }

    @Override
    public Query createLuceneQuery(com.atlassian.query.Query jiraQuery, boolean ignorePermissions) throws SearchException {
        if (jiraQuery.getWhereClause() == null) {
            return new Query33.Factory().createMatchAllQuery();
        }
        QueryCreationContext context = this.getQueryCreationContext(ignorePermissions);
        return new Query33(this.luceneQueryBuilder.createLuceneQuery(context, jiraQuery.getWhereClause()));
    }

    private QueryCreationContext getQueryCreationContext(boolean ignorePermissions) {
        return new QueryCreationContextImpl(ignorePermissions ? null : this.authenticationContext.getUser(), ignorePermissions);
    }
}

