/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.user;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.user.UserSearchServiceBridge;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.user.UserSearchServiceBridge710")
@SupportedVersions(all=true)
public class UserSearchServiceBridge710
implements UserSearchServiceBridge {
    private final UserSearchService userSearchService;

    @Autowired
    public UserSearchServiceBridge710(UserSearchService userSearchService) {
        this.userSearchService = userSearchService;
    }

    @Override
    public List<ApplicationUser> findUsersByName(ApplicationUser loggedInUser, String query, Optional<Integer> maxResults, Collection<String> excludes) {
        HashSet excludesHash = excludes != null ? Sets.newHashSet(excludes) : Sets.newHashSet();
        UserSearchParams.Builder params = UserSearchParams.builder().allowEmptyQuery(true).includeActive(true).includeInactive(false).ignorePermissionCheck(false);
        if (maxResults.isPresent()) {
            params.maxResults(Integer.valueOf((Integer)maxResults.get() + excludesHash.size()));
        }
        List matchingUsers = this.userSearchService.findUsers((JiraServiceContext)new JiraServiceContextImpl(loggedInUser), query, params.build());
        if (excludesHash.size() > 0) {
            List<ApplicationUser> nonExcludedUsers = matchingUsers.stream().filter(applicationUser -> !excludesHash.contains(applicationUser.getKey())).collect(Collectors.toList());
            if (maxResults.isPresent()) {
                return Lists.newArrayList((Iterable)Iterables.limit(nonExcludedUsers, (int)((Integer)maxResults.get())));
            }
            return nonExcludedUsers;
        }
        return matchingUsers;
    }
}

